/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.traits.protocols.AwsJson1_0Trait;
import software.amazon.smithy.aws.traits.protocols.AwsJson1_1Trait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryTrait;
import software.amazon.smithy.aws.traits.protocols.Ec2QueryTrait;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.aws.traits.protocols.RestXmlTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ErrorRenameValidator
extends AbstractValidator {
    private static final Set<ShapeId> UNSUPPORTED_PROTOCOLS = SetUtils.of((Object[])new ShapeId[]{AwsJson1_0Trait.ID, AwsJson1_1Trait.ID, AwsQueryTrait.ID, Ec2QueryTrait.ID, RestJson1Trait.ID, RestXmlTrait.ID});

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape shape : model.getServiceShapes()) {
            this.validate(model, shape, events);
        }
        return events;
    }

    private void validate(Model model, ServiceShape service, List<ValidationEvent> events) {
        Map renames = service.getRename();
        if (renames.isEmpty()) {
            return;
        }
        HashSet<String> unsupportedProtocols = new HashSet<String>();
        for (ShapeId protocol : UNSUPPORTED_PROTOCOLS) {
            if (!service.getAllTraits().containsKey(protocol)) continue;
            unsupportedProtocols.add(protocol.getName());
        }
        if (unsupportedProtocols.isEmpty()) {
            return;
        }
        renames.keySet().forEach(shapeId -> {
            Optional shape = model.getShape(shapeId);
            if (!shape.isPresent() || !((Shape)shape.get()).hasTrait(ErrorTrait.ID)) {
                return;
            }
            ShapeId from = ((Shape)shape.get()).getId();
            String to = (String)renames.get(from);
            events.add(this.error((Shape)service, String.format("Service attempts to rename an error shape from `%s` to \"%s\"; Service protocols %s do not support error renaming.", from, to, unsupportedProtocols)));
        });
    }
}

