/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ServiceTaggingValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        AwsTagIndex awsTagIndex = AwsTagIndex.of(model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            events.addAll(this.validateService(service, awsTagIndex));
        }
        return events;
    }

    private List<ValidationEvent> validateService(ServiceShape service, AwsTagIndex awsTagIndex) {
        Optional<ShapeId> listTagsId;
        Optional<ShapeId> untagResourceId;
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TagEnabledTrait trait = (TagEnabledTrait)service.expectTrait(TagEnabledTrait.class);
        Optional<ShapeId> tagResourceId = awsTagIndex.getTagResourceOperation((ToShapeId)service.getId());
        if (tagResourceId.isPresent()) {
            if (!awsTagIndex.serviceHasValidTagResourceOperation((ToShapeId)service.getId())) {
                events.add(this.getInvalidOperationEvent(service, (FromSourceLocation)trait, tagResourceId.get(), "TagResource"));
            }
        } else {
            events.add(this.getMissingOperationEvent(service, (FromSourceLocation)trait, "TagResource"));
        }
        if ((untagResourceId = awsTagIndex.getUntagResourceOperation((ToShapeId)service.getId())).isPresent()) {
            if (!awsTagIndex.serviceHasValidUntagResourceOperation((ToShapeId)service.getId())) {
                events.add(this.getInvalidOperationEvent(service, (FromSourceLocation)trait, untagResourceId.get(), "UntagResource"));
            }
        } else {
            events.add(this.getMissingOperationEvent(service, (FromSourceLocation)trait, "UntagResource"));
        }
        if ((listTagsId = awsTagIndex.getListTagsForResourceOperation((ToShapeId)service.getId())).isPresent()) {
            if (!awsTagIndex.serviceHasValidListTagsForResourceOperation((ToShapeId)service.getId())) {
                events.add(this.getInvalidOperationEvent(service, (FromSourceLocation)trait, listTagsId.get(), "ListTagsForResource"));
            }
        } else {
            events.add(this.getMissingOperationEvent(service, (FromSourceLocation)trait, "ListTagsForResource"));
        }
        return events;
    }

    private ValidationEvent getMissingOperationEvent(ServiceShape service, FromSourceLocation location, String opName) {
        return this.warning((Shape)service, location, "Service marked `aws.api#TagEnabled` is missing an operation named '" + opName + ".'");
    }

    private ValidationEvent getInvalidOperationEvent(ServiceShape service, FromSourceLocation location, ShapeId opId, String opName) {
        return this.danger((Shape)service, location, String.format("Shape `%s` does not satisfy '%s' operation requirements.", opId.toString(), opName));
    }
}

