/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ArnTrait
extends AbstractTrait
implements ToSmithyBuilder<ArnTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#arn");
    private static final String TEMPLATE = "template";
    private static final String ABSOLUTE = "absolute";
    private static final String NO_REGION = "noRegion";
    private static final String NO_ACCOUNT = "noAccount";
    private static final Pattern PATTERN = Pattern.compile("\\{([^}]+)}");
    private final boolean noRegion;
    private final boolean noAccount;
    private final boolean absolute;
    private final String template;
    private final List<String> labels;

    private ArnTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.template = (String)SmithyBuilder.requiredState((String)TEMPLATE, (Object)builder.template);
        this.noRegion = builder.noRegion;
        this.noAccount = builder.noAccount;
        this.absolute = builder.absolute;
        this.labels = Collections.unmodifiableList(ArnTrait.parseLabels(this.template));
        if (this.template.startsWith("/")) {
            throw new SourceException("Invalid aws.api#arn trait. The template must not start with '/'. Found `" + this.template + "`", (FromSourceLocation)this.getSourceLocation());
        }
    }

    private static List<String> parseLabels(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = PATTERN.matcher(resource);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNoAccount() {
        return this.noAccount;
    }

    public boolean isNoRegion() {
        return this.noRegion;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public String getTemplate() {
        return this.template;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    protected Node createNode() {
        return Node.objectNode().withMember(TEMPLATE, (ToNode)Node.from((String)this.getTemplate())).withMember(ABSOLUTE, (ToNode)Node.from((boolean)this.isAbsolute())).withMember(NO_ACCOUNT, (ToNode)Node.from((boolean)this.isNoAccount())).withMember(NO_REGION, (ToNode)Node.from((boolean)this.isNoRegion()));
    }

    public Builder toBuilder() {
        return ((Builder)ArnTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).noRegion(this.isNoRegion()).noAccount(this.isNoAccount()).template(this.getTemplate());
    }

    public static final class Builder
    extends AbstractTraitBuilder<ArnTrait, Builder> {
        private boolean noRegion;
        private boolean noAccount;
        private boolean absolute;
        private String template;

        private Builder() {
        }

        public ArnTrait build() {
            return new ArnTrait(this);
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder absolute(boolean absolute) {
            this.absolute = absolute;
            return this;
        }

        public Builder noAccount(boolean noAccount) {
            this.noAccount = noAccount;
            return this;
        }

        public Builder noRegion(boolean noRegion) {
            this.noRegion = noRegion;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = ArnTrait.builder();
            ObjectNode objectNode = value.expectObjectNode();
            builder.template(objectNode.expectStringMember(ArnTrait.TEMPLATE).getValue());
            builder.absolute(objectNode.getBooleanMemberOrDefault(ArnTrait.ABSOLUTE));
            builder.noRegion(objectNode.getBooleanMemberOrDefault(ArnTrait.NO_REGION));
            builder.noAccount(objectNode.getBooleanMemberOrDefault(ArnTrait.NO_ACCOUNT));
            return builder.build();
        }
    }
}

