/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.Pair;

public final class FlattenNamespaces
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        if (config.getService() == null || config.getNamespace() == null) {
            throw new SmithyBuildException("'namespace' and 'service' properties must be set on flattenNamespace transformer.");
        }
        Model model = context.getModel();
        Map<ShapeId, ShapeId> shapesToRename = this.getRenamedShapes(config, model);
        return ModelTransformer.create().renameShapes(model, shapesToRename);
    }

    @Override
    public String getName() {
        return "flattenNamespaces";
    }

    private Map<ShapeId, ShapeId> getRenamedShapes(Config config, Model model) {
        if (!model.getShape(config.getService()).isPresent()) {
            throw new SmithyBuildException("Configured service, " + config.getService() + ", not found in model when performing flattenNamespaces transform.");
        }
        Map<ShapeId, ShapeId> shapesToRename = this.getRenamedShapesConnectedToService(config, model);
        Set<ShapeId> taggedShapesToInclude = this.getTaggedShapesToInclude(config.getIncludeTagged(), model);
        for (ShapeId id : taggedShapesToInclude) {
            ShapeId updatedShapeId = this.updateNamespace(id, config.getNamespace());
            if (shapesToRename.containsValue(updatedShapeId)) continue;
            shapesToRename.put(id, updatedShapeId);
        }
        return shapesToRename;
    }

    private ShapeId updateNamespace(ShapeId shapeId, String namespace) {
        if (shapeId.getMember().isPresent()) {
            return ShapeId.fromParts((String)namespace, (String)shapeId.getName(), (String)((String)shapeId.getMember().get()));
        }
        return ShapeId.fromParts((String)namespace, (String)shapeId.getName());
    }

    private Map<ShapeId, ShapeId> getRenamedShapesConnectedToService(Config config, Model model) {
        Walker shapeWalker = new Walker(NeighborProviderIndex.of((Model)model).getProvider());
        ServiceShape service = (ServiceShape)model.expectShape(config.getService(), ServiceShape.class);
        return shapeWalker.walkShapes((Shape)service).stream().filter(FunctionalUtils.not(Prelude::isPreludeShape)).map(shape -> Pair.of((Object)shape.getId(), (Object)this.updateNamespace(shape.getId(), config.getNamespace()))).map(pair -> this.applyServiceRenames((ShapeId)pair.getLeft(), (ShapeId)pair.getRight(), service)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private Pair<ShapeId, ShapeId> applyServiceRenames(ShapeId fromId, ShapeId toId, ServiceShape service) {
        if (service.getRename().containsKey(fromId)) {
            ShapeId newId = ShapeId.fromParts((String)toId.getNamespace(), (String)((String)service.getRename().get(fromId)));
            return Pair.of((Object)fromId, (Object)newId);
        }
        return Pair.of((Object)fromId, (Object)toId);
    }

    private Set<ShapeId> getTaggedShapesToInclude(Set<String> tags, Model model) {
        return model.shapes().filter(FunctionalUtils.not(Prelude::isPreludeShape)).filter(shape -> this.isTagged(tags, (Shape)shape)).map(Shape::getId).collect(Collectors.toSet());
    }

    private boolean isTagged(Set<String> tags, Shape shape) {
        return shape.getTags().stream().anyMatch(tags::contains);
    }

    public static final class Config {
        private String namespace;
        private ShapeId service;
        private Set<String> tags = Collections.emptySet();

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setService(ShapeId service) {
            this.service = service;
        }

        public ShapeId getService() {
            return this.service;
        }

        public void setIncludeTagged(Set<String> tags) {
            this.tags = tags;
        }

        public Set<String> getIncludeTagged() {
            return this.tags;
        }
    }
}

