/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public final class ExcludeShapesByTrait
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public String getName() {
        return "excludeShapesByTrait";
    }

    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        HashSet<ShapeId> ids = new HashSet<ShapeId>(config.getTraits().size());
        for (String id : config.getTraits()) {
            ids.add(ShapeId.fromOptionalNamespace((String)"smithy.api", (String)id));
        }
        return context.getTransformer().removeShapesIf(context.getModel(), shape -> ids.stream().anyMatch(arg_0 -> ((Shape)shape).hasTrait(arg_0)));
    }

    public static final class Config {
        private Set<String> traits = Collections.emptySet();

        public Set<String> getTraits() {
            return this.traits;
        }

        public void setTraits(Set<String> traits) {
            this.traits = traits;
        }
    }
}

