/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeShapesByTag
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "includeShapesByTag";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "tags";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Set<String> includeTags = config.getTags();
        ModelTransformer transformer = context.getTransformer();
        Model model = context.getModel();
        return transformer.filterShapes(model, shape -> {
            if (Prelude.isPreludeShape((ToShapeId)shape)) return true;
            if (!shape.getTags().stream().anyMatch(includeTags::contains)) return false;
            return true;
        });
    }

    public static final class Config {
        private Set<String> tags = Collections.emptySet();

        public Set<String> getTags() {
            return this.tags;
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }
    }
}

