/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;

final class SmithyBuildUtils {
    private SmithyBuildUtils() {
    }

    static String resolveImportPath(Path basePath, Node node) {
        String value = node.expectStringNode().getValue();
        return basePath == null ? value : basePath.resolve(value).toString();
    }

    static ObjectNode loadAndExpandJson(String path, String contents) {
        Node result = Node.parseJsonWithComments((String)contents, (String)path);
        if (contents.contains("${")) {
            result = (Node)result.accept((NodeVisitor)new VariableExpander());
        }
        return result.expectObjectNode();
    }

    static Path getBasePathFromSourceLocation(FromSourceLocation fromSourceLocation) {
        SourceLocation sourceLocation = fromSourceLocation.getSourceLocation();
        Path path = null;
        if (sourceLocation != SourceLocation.NONE) {
            path = Paths.get(sourceLocation.getFilename(), new String[0]).getParent();
        }
        if (path == null) {
            path = SmithyBuildUtils.getCurrentWorkingDirectory();
        }
        return path;
    }

    static Path getCurrentWorkingDirectory() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    static ObjectNode expandNode(Node node) {
        return ((Node)node.accept((NodeVisitor)new VariableExpander())).expectObjectNode();
    }

    private static final class VariableExpander
    extends NodeVisitor.Default<Node> {
        private static final Pattern INLINE = Pattern.compile("(?:^|[^\\\\])\\$\\{(.+)}");
        private static final Pattern ESCAPED_INLINE = Pattern.compile("\\\\\\$");

        private VariableExpander() {
        }

        protected Node getDefault(Node node) {
            return node;
        }

        public Node arrayNode(ArrayNode node) {
            ArrayList<Node> result = new ArrayList<Node>(node.size());
            for (Node element : node.getElements()) {
                result.add((Node)element.accept((NodeVisitor)this));
            }
            return new ArrayNode(result, node.getSourceLocation());
        }

        public Node objectNode(ObjectNode node) {
            LinkedHashMap<StringNode, Node> result = new LinkedHashMap<StringNode, Node>(node.size());
            for (Map.Entry entry : node.getMembers().entrySet()) {
                result.put(((Node)((StringNode)entry.getKey()).accept((NodeVisitor)this)).expectStringNode(), (Node)((Node)entry.getValue()).accept((NodeVisitor)this));
            }
            return new ObjectNode(result, node.getSourceLocation());
        }

        public Node stringNode(StringNode node) {
            Matcher matcher = INLINE.matcher(node.getValue());
            StringBuffer builder = new StringBuffer();
            while (matcher.find()) {
                String variable = matcher.group(1);
                String replacement = VariableExpander.expand(node.getSourceLocation(), variable);
                if (!matcher.group(0).startsWith("${")) {
                    replacement = matcher.group(0).charAt(0) + replacement;
                }
                matcher.appendReplacement(builder, replacement);
            }
            matcher.appendTail(builder);
            String result = ESCAPED_INLINE.matcher(builder.toString()).replaceAll("\\$");
            return new StringNode(result, node.getSourceLocation());
        }

        private static String expand(SourceLocation sourceLocation, String variable) {
            if (variable.equals("SMITHY_ROOT_DIR")) {
                return SmithyBuildUtils.getCurrentWorkingDirectory().toString();
            }
            String replacement = Optional.ofNullable(System.getProperty(variable)).orElseGet(() -> System.getenv(variable));
            if (replacement == null) {
                throw new SmithyBuildException(String.format("Unable to expand variable `" + variable + "` to an environment variable or system property: %s", sourceLocation));
            }
            return replacement;
        }
    }
}

