/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class TagUtils {
    private TagUtils() {
    }

    static Model excludeShapeTags(ModelTransformer transformer, Model model, Set<String> tags) {
        return TagUtils.includeExcludeShapeTags(transformer, model, tags, true);
    }

    static Model includeShapeTags(ModelTransformer transformer, Model model, Set<String> tags) {
        return TagUtils.includeExcludeShapeTags(transformer, model, tags, false);
    }

    private static Model includeExcludeShapeTags(ModelTransformer transformer, Model model, Set<String> tags, boolean exclude) {
        return transformer.mapShapes(model, shape -> TagUtils.intersectIfChanged(shape.getTags(), tags, exclude).map(intersection -> {
            TagsTrait.Builder builder = TagsTrait.builder();
            intersection.forEach(arg_0 -> ((TagsTrait.Builder)builder).addValue(arg_0));
            return (Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)builder.build()).build();
        }).orElse((Shape)shape));
    }

    private static Optional<Set<String>> intersectIfChanged(Collection<String> subject, Collection<String> other, boolean exclude) {
        HashSet<String> temp = new HashSet<String>(subject);
        if (exclude) {
            temp.removeAll(other);
        } else {
            temp.retainAll(other);
        }
        return temp.size() == subject.size() ? Optional.empty() : Optional.of(temp);
    }
}

