/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.FunctionalUtils;

public final class ExcludeShapesBySelector
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "excludeShapesBySelector";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Selector selector = config.getSelector();
        ModelTransformer transformer = context.getTransformer();
        Model model = context.getModel();
        Set selected = selector.select(model);
        return transformer.filterShapes(model, FunctionalUtils.not(selected::contains));
    }

    public static final class Config {
        private Selector selector = null;

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }
    }
}

