/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.build.plugins.BuildInfo;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;

public final class BuildInfoPlugin
implements SmithyBuildPlugin {
    public static final String BUILD_INFO_PATH = "smithy-build-info.json";
    private static final String NAME = "build-info";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresValidModel() {
        return false;
    }

    @Override
    public void execute(PluginContext context) {
        if (context.getOriginalModel().isPresent() && context.getProjection().isPresent()) {
            context.getFileManifest().writeJson(BUILD_INFO_PATH, BuildInfoPlugin.serializeBuildInfo(context));
        }
    }

    private static Node serializeBuildInfo(PluginContext context) {
        BuildInfo info = new BuildInfo();
        info.setProjectionName(context.getProjectionName());
        info.setProjection(context.getProjection().orElse(null));
        info.setValidationEvents(context.getEvents());
        Set<ShapeId> traitIds = BuildInfoPlugin.getTraitShapeIds(context.getModel());
        info.setTraitNames(BuildInfoPlugin.findTraitNames(context.getModel(), traitIds));
        info.setTraitDefNames(new ArrayList<ShapeId>(traitIds));
        info.setServiceShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), ServiceShape.class));
        info.setOperationShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), OperationShape.class));
        info.setResourceShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), ResourceShape.class));
        info.setMetadata(context.getModel().getMetadata());
        NodeMapper mapper = new NodeMapper();
        return mapper.serialize((Object)info);
    }

    private static Set<ShapeId> getTraitShapeIds(Model model) {
        Set traits = model.getShapesWithTrait(TraitDefinition.class);
        TreeSet<ShapeId> result = new TreeSet<ShapeId>();
        for (Shape traitShape : traits) {
            result.add(traitShape.getId());
        }
        return result;
    }

    private static List<ShapeId> findTraitNames(Model model, Set<ShapeId> traitIds) {
        ArrayList applied = new ArrayList(model.getAppliedTraits());
        ArrayList<ShapeId> traitNames = new ArrayList<ShapeId>();
        for (ShapeId shapeId : applied) {
            if (!traitIds.contains(shapeId)) continue;
            traitNames.add(shapeId);
        }
        Collections.sort(traitNames);
        return traitNames;
    }

    private static <T extends Shape> List<ShapeId> findShapeIds(Model model, Class<T> clazz) {
        Set shapes = model.toSet(clazz);
        ArrayList<ShapeId> result = new ArrayList<ShapeId>(shapes.size());
        for (Shape s : shapes) {
            result.add(s.getId());
        }
        Collections.sort(result);
        return result;
    }
}

