/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.df;

import java.util.Collections;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.CollectRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.DependencyManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.DependencySelector;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.DependencyTraverser;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.VersionFilter;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DefaultDependencyNode;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.Dependency;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyNode;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.ArtifactDescriptorReader;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RemoteRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionRangeResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.DataPool;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.PremanagedDependency;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect.df.NodeStack;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.Version;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named(value="df")
public class DfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    public static final String NAME = "df";

    @Deprecated
    public DfDependencyCollector() {
    }

    @Inject
    DfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        NodeStack nodes = new NodeStack();
        nodes.push(node);
        Args args = new Args(session, pool, nodes, context, versionContext, request);
        this.process(args, trace, results, dependencies, repositories, session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector(context) : null, session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager(context) : null, session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser(context) : null, session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter(context) : null);
    }

    private void process(Args args, RequestTrace trace, DependencyCollectorDelegate.Results results, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter) {
        for (Dependency dependency : dependencies) {
            this.processDependency(args, trace, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency);
        }
    }

    private void processDependency(Args args, RequestTrace trace, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency) {
        List<Artifact> relocations = Collections.emptyList();
        this.processDependency(args, trace, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency, relocations, false);
    }

    private void processDependency(Args args, RequestTrace parent, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency, List<Artifact> relocations, boolean disableVersionManagement) {
        List<? extends Version> versions;
        VersionRangeResult rangeResult;
        if (depSelector != null && !depSelector.selectDependency(dependency)) {
            return;
        }
        RequestTrace trace = this.collectStepTrace(parent, args.request.getRequestContext(), args.nodes.nodes, dependency);
        PremanagedDependency preManaged = PremanagedDependency.create(depManager, dependency, disableVersionManagement, args.premanagedState);
        boolean noDescriptor = DfDependencyCollector.isLackingDescriptor((dependency = preManaged.getManagedDependency()).getArtifact());
        boolean traverse = !noDescriptor && (depTraverser == null || depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = DfDependencyCollector.createVersionRangeRequest(args.request.getRequestContext(), trace, repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args.pool, args.session);
            versions = DfDependencyCollector.filterVersions(dependency, rangeResult, verFilter, args.versionContext);
        }
        catch (VersionRangeResolutionException e) {
            results.addException(dependency, e, args.nodes.nodes);
            return;
        }
        for (Version version : versions) {
            DependencyNode node;
            ArtifactDescriptorRequest descriptorRequest;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = this.getArtifactDescriptorResult(args, results, noDescriptor, d, descriptorRequest = DfDependencyCollector.createArtifactDescriptorRequest(args.request.getRequestContext(), trace, repositories, d));
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                d = d.setArtifact(descriptorResult.getArtifact());
                node = args.nodes.top();
                int cycleEntry = DefaultDependencyCycle.find(args.nodes.nodes, d.getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(args.nodes.nodes, cycleEntry, d);
                    DependencyNode cycleNode = args.nodes.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        node.getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    this.processDependency(args, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
                child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args.request.getRequestContext());
                node.getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                if (!recurse) continue;
                this.doRecurse(args, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult, child);
                continue;
            }
            node = args.nodes.top();
            List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
            DefaultDependencyNode child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args.request.getRequestContext());
            node.getChildren().add(child);
        }
    }

    private void doRecurse(Args args, RequestTrace trace, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency d, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args.collectionContext;
        context.set(d, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = depSelector != null ? depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = depManager != null ? depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = depTraverser != null ? depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = verFilter != null ? verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args.ignoreRepos ? repositories : this.remoteRepositoryManager.aggregateRepositories(args.session, repositories, descriptorResult.getRepositories(), true);
        Object key = args.pool.toKey(d.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children = args.pool.getChildren(key);
        if (children == null) {
            args.pool.putChildren(key, child.getChildren());
            args.nodes.push(child);
            this.process(args, trace, results, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser, childFilter);
            args.nodes.pop();
        } else {
            child.setChildren(children);
        }
    }

    private ArtifactDescriptorResult getArtifactDescriptorResult(Args args, DependencyCollectorDelegate.Results results, boolean noDescriptor, Dependency d, ArtifactDescriptorRequest descriptorRequest) {
        return noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args.pool, descriptorRequest, args.session, d, results, args);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session, Dependency d, DependencyCollectorDelegate.Results results, Args args) {
        Object key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(d, e, args.nodes.nodes);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final NodeStack nodes;
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;

        Args(RepositorySystemSession session, DataPool pool, NodeStack nodes, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session, false, "aether.dependencyManager.verbose");
            this.pool = pool;
            this.nodes = nodes;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
        }
    }
}

