/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.HelpPrinter;

final class BuildOptions
implements ArgumentReceiver {
    static final String ALLOW_UNKNOWN_TRAITS = "--allow-unknown-traits";
    static final String MODELS = "<MODELS>";
    private boolean allowUnknownTraits;
    private String output;
    private boolean noPositionalArguments;

    BuildOptions() {
    }

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.option(ALLOW_UNKNOWN_TRAITS, null, "Ignore unknown traits when validating models.");
        printer.param("--output", null, "OUTPUT_PATH", "Where to write Smithy artifacts, caches, and other files (defaults to './build/smithy').");
        if (!this.noPositionalArguments) {
            printer.positional(MODELS, "Model files and directories to load.");
        }
    }

    @Override
    public boolean testOption(String name) {
        if (ALLOW_UNKNOWN_TRAITS.equals(name)) {
            this.allowUnknownTraits = true;
            return true;
        }
        return false;
    }

    @Override
    public Consumer<String> testParameter(String name) {
        if ("--output".equals(name)) {
            return value -> {
                this.output = value;
            };
        }
        return null;
    }

    boolean allowUnknownTraits() {
        return this.allowUnknownTraits;
    }

    String output() {
        return this.output;
    }

    void noPositionalArguments(boolean noPositionalArguments) {
        this.noPositionalArguments = noPositionalArguments;
    }

    Path resolveOutput(SmithyBuildConfig config) {
        if (this.output != null) {
            return Paths.get(this.output, new String[0]);
        }
        return config.getOutputDirectory().map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(SmithyBuild::getDefaultOutputDirectory);
    }
}

