/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.testrunner;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ModelDiff;
import software.amazon.smithy.diff.testrunner.SmithyDiffTestCase;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;

public final class SmithyDiffTestSuite {
    static final String EVENTS = ".events";
    private static final String DEFAULT_TEST_CASE_LOCATION = "diffs";
    private static final String EXT_SMITHY = ".smithy";
    private static final String EXT_JSON = ".json";
    private static final String MODEL_A = ".a";
    private static final String MODEL_B = ".b";
    private final List<SmithyDiffTestCase> cases = new ArrayList<SmithyDiffTestCase>();
    private Supplier<ModelAssembler> modelAssemblerFactory = ModelAssembler::new;

    private SmithyDiffTestSuite() {
    }

    public static SmithyDiffTestSuite runner() {
        return new SmithyDiffTestSuite();
    }

    public static Stream<Object[]> defaultParameterizedTestSource(Class<?> contextClass) {
        ClassLoader classLoader = contextClass.getClassLoader();
        ModelAssembler assembler = Model.assembler((ClassLoader)classLoader).discoverModels(classLoader);
        return SmithyDiffTestSuite.runner().setModelAssemblerFactory(() -> ((ModelAssembler)assembler).copy()).addTestCasesFromUrl(contextClass.getResource(DEFAULT_TEST_CASE_LOCATION)).parameterizedTestSource();
    }

    public Stream<Object[]> parameterizedTestSource() {
        return this.cases.stream().map(testCase -> {
            Callable<SmithyDiffTestCase.Result> callable = this.createTestCaseCallable((SmithyDiffTestCase)testCase);
            Callable<SmithyDiffTestCase.Result> wrappedCallable = () -> ((SmithyDiffTestCase.Result)callable.call()).unwrap();
            return new Object[]{testCase.getName(), wrappedCallable};
        });
    }

    public SmithyDiffTestSuite addTestCase(SmithyDiffTestCase testCase) {
        this.cases.add(testCase);
        return this;
    }

    public SmithyDiffTestSuite addTestCasesFromDirectory(Path modelDirectory) {
        SmithyDiffTestSuite smithyDiffTestSuite;
        block8: {
            Stream<Path> files = Files.walk(modelDirectory, new FileVisitOption[0]);
            try {
                String modelDirectoryName = modelDirectory.toString();
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(fileName -> fileName.endsWith(EVENTS)).map(fileName -> SmithyDiffTestCase.from(modelDirectory, fileName.substring(modelDirectoryName.length() + 1, fileName.length() - EVENTS.length()))).forEach(this::addTestCase);
                smithyDiffTestSuite = this;
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return smithyDiffTestSuite;
    }

    public SmithyDiffTestSuite addTestCasesFromUrl(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Only file URLs are supported by the testrunner: " + url);
        }
        try {
            return this.addTestCasesFromDirectory(Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SmithyDiffTestSuite setModelAssemblerFactory(Supplier<ModelAssembler> modelAssemblerFactory) {
        this.modelAssemblerFactory = Objects.requireNonNull(modelAssemblerFactory);
        return this;
    }

    public Stream<Callable<SmithyDiffTestCase.Result>> testCaseCallables() {
        return this.cases.stream().map(this::createTestCaseCallable);
    }

    private Callable<SmithyDiffTestCase.Result> createTestCaseCallable(SmithyDiffTestCase testCase) {
        return () -> testCase.createResult(ModelDiff.compare(SmithyDiffTestSuite.getModel(testCase, this.modelAssemblerFactory.get(), MODEL_A), SmithyDiffTestSuite.getModel(testCase, this.modelAssemblerFactory.get(), MODEL_B)));
    }

    private static Model getModel(SmithyDiffTestCase testCase, ModelAssembler assembler, String infix) {
        Path modelPath = testCase.getPath().resolve(testCase.getName() + infix + EXT_SMITHY);
        if (!Files.exists(modelPath, new LinkOption[0])) {
            modelPath = modelPath.resolveSibling(testCase.getName() + infix + EXT_JSON);
        }
        return (Model)assembler.addImport(modelPath).assemble().unwrap();
    }

    public Result run() {
        return this.run(ForkJoinPool.commonPool());
    }

    public Result run(ExecutorService executorService) {
        List<SmithyDiffTestCase.Result> failedResults = Collections.synchronizedList(new ArrayList());
        List callables = this.testCaseCallables().collect(Collectors.toList());
        try {
            for (Future<SmithyDiffTestCase.Result> result2 : executorService.invokeAll(callables)) {
                SmithyDiffTestCase.Result testCaseResult = this.waitOnFuture(result2);
                if (!testCaseResult.isInvalid()) continue;
                failedResults.add(testCaseResult);
            }
            Result result = new Result(callables.size() - failedResults.size(), failedResults);
            if (failedResults.isEmpty()) {
                Result result2 = result;
                return result2;
            }
            try {
                throw new Error(result);
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                throw new Error("Error executing test suite: " + e.getMessage(), e);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private SmithyDiffTestCase.Result waitOnFuture(Future<SmithyDiffTestCase.Result> future) throws InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error("Error executing test case: " + e.getMessage(), cause);
        }
    }

    public static final class Result {
        private final int successCount;
        private final List<SmithyDiffTestCase.Result> failedResults;

        Result(int successCount, List<SmithyDiffTestCase.Result> failedResults) {
            this.successCount = successCount;
            this.failedResults = Collections.unmodifiableList(failedResults);
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public List<SmithyDiffTestCase.Result> getFailedResults() {
            return this.failedResults;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Smithy diff test runner encountered %d successful result(s), and %d failed result(s)", this.successCount, this.failedResults.size()));
            this.failedResults.forEach(failed -> builder.append('\n').append(failed.toString()).append('\n'));
            return builder.toString();
        }
    }

    public static final class Error
    extends RuntimeException {
        public final Result result;

        Error(Result result) {
            super(result.toString());
            this.result = result;
        }

        Error(String message, Throwable previous) {
            super(message, previous);
            this.result = new Result(0, Collections.emptyList());
        }
    }
}

