/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.Arrays;
import java.util.List;
import software.amazon.smithy.jmespath.RuntimeType;
import software.amazon.smithy.jmespath.ast.LiteralExpression;

final class FunctionDefinition {
    final LiteralExpression returnValue;
    final List<ArgValidator> arguments;
    final ArgValidator variadic;

    FunctionDefinition(LiteralExpression returnValue, ArgValidator ... arguments) {
        this(returnValue, Arrays.asList(arguments), null);
    }

    FunctionDefinition(LiteralExpression returnValue, List<ArgValidator> arguments, ArgValidator variadic) {
        this.returnValue = returnValue;
        this.arguments = arguments;
        this.variadic = variadic;
    }

    static ArgValidator isType(RuntimeType type) {
        return arg -> {
            if (type == RuntimeType.ANY || arg.getType() == RuntimeType.ANY) {
                return null;
            }
            if (arg.getType() == type) {
                return null;
            }
            return "Expected argument to be " + (Object)((Object)type) + ", but found " + (Object)((Object)arg.getType());
        };
    }

    static ArgValidator listOfType(RuntimeType type) {
        return arg -> {
            if (type == RuntimeType.ANY || arg.getType() == RuntimeType.ANY) {
                return null;
            }
            if (arg.getType() == RuntimeType.ARRAY) {
                List<Object> values = arg.expectArrayValue();
                for (int i = 0; i < values.size(); ++i) {
                    LiteralExpression element = LiteralExpression.from(values.get(i));
                    if (element.getType() == type) continue;
                    return "Expected an array of " + (Object)((Object)type) + ", but found " + (Object)((Object)element.getType()) + " at index " + i;
                }
            } else {
                return "Expected argument to be an array, but found " + (Object)((Object)arg.getType());
            }
            return null;
        };
    }

    static ArgValidator oneOf(RuntimeType ... types) {
        return arg -> {
            if (arg.getType() == RuntimeType.ANY) {
                return null;
            }
            for (RuntimeType type : types) {
                if (arg.getType() != type && type != RuntimeType.ANY) continue;
                return null;
            }
            return "Expected one of " + Arrays.toString((Object[])types) + ", but found " + (Object)((Object)arg.getType());
        };
    }

    @FunctionalInterface
    static interface ArgValidator {
        public String validate(LiteralExpression var1);
    }
}

