/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.ast.BinaryExpression;

public final class FilterProjectionExpression
extends BinaryExpression {
    private final JmespathExpression comparison;

    public FilterProjectionExpression(JmespathExpression left, JmespathExpression comparison, JmespathExpression right) {
        this(left, comparison, right, 1, 1);
    }

    public FilterProjectionExpression(JmespathExpression left, JmespathExpression comparison, JmespathExpression right, int line, int column) {
        super(left, right, line, column);
        this.comparison = comparison;
    }

    public JmespathExpression getComparison() {
        return this.comparison;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitFilterProjection(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterProjectionExpression)) {
            return false;
        }
        FilterProjectionExpression that = (FilterProjectionExpression)o;
        return this.getComparison().equals(that.getComparison()) && this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getComparison(), this.getLeft(), this.getRight());
    }

    @Override
    public String toString() {
        return "FilterProjectionExpression{comparison=" + this.comparison + ", left=" + this.getLeft() + ", right=" + this.getRight() + '}';
    }
}

