/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.Objects;

public final class ExpressionProblem
implements Comparable<ExpressionProblem> {
    public final String message;
    public final int line;
    public final int column;
    public final Severity severity;

    ExpressionProblem(Severity severity, int line, int column, String message) {
        this.severity = severity;
        this.line = line;
        this.column = column;
        this.message = message;
    }

    public String toString() {
        return "[" + (Object)((Object)this.severity) + "] " + this.message + " (" + this.line + ":" + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionProblem)) {
            return false;
        }
        ExpressionProblem problem = (ExpressionProblem)o;
        return this.severity == problem.severity && this.line == problem.line && this.column == problem.column && this.message.equals(problem.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.message, this.line, this.column});
    }

    @Override
    public int compareTo(ExpressionProblem o) {
        return this.toString().compareTo(o.toString());
    }

    public static enum Severity {
        ERROR,
        DANGER,
        WARNING;

    }
}

