/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;

public final class StandardOperationVerbValidator
extends AbstractValidator {
    private final Config config;

    private StandardOperationVerbValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        return model.shapes(OperationShape.class).flatMap(shape -> OptionalUtils.stream(this.validateShape((OperationShape)shape, this.config))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateShape(OperationShape operation, Config config) {
        String name;
        List words = ValidationUtils.splitCamelCaseWord((String)operation.getId().getName());
        String foundPrefix = null;
        if (!config.getPrefixes().contains(words.get(0))) {
            name = (String)words.get(0);
        } else {
            if (words.size() == 1) {
                return Optional.of(this.danger((Shape)operation, String.format("Operation name consists of only a verb prefix: %s", operation.getId().getName())));
            }
            foundPrefix = (String)words.get(0);
            name = (String)words.get(1);
        }
        if (config.getSuggestAlternatives().containsKey(name)) {
            return Optional.of(this.danger((Shape)operation, String.format("%s Consider using one of the following verbs instead: %s", StandardOperationVerbValidator.createMessagePrefix((Shape)operation, name, foundPrefix), ValidationUtils.tickedList((Collection)config.getSuggestAlternatives().get(name)))));
        }
        if (!config.getVerbs().contains(name)) {
            return Optional.of(this.danger((Shape)operation, String.format("%s Expected one of the following verbs: %s", StandardOperationVerbValidator.createMessagePrefix((Shape)operation, name, foundPrefix), ValidationUtils.tickedList(config.getVerbs()))));
        }
        return Optional.empty();
    }

    private static String createMessagePrefix(Shape shape, String name, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Operation shape `%s` uses a non-standard verb, `%s`", shape.getId().getName(), name));
        if (prefix != null) {
            builder.append(String.format(", with a detected prefix of `%s`", prefix));
        }
        return builder.append(".").toString();
    }

    public static final class Config {
        private List<String> verbs = Collections.emptyList();
        private List<String> prefixes = Collections.emptyList();
        private Map<String, List<String>> suggestAlternatives = Collections.emptyMap();

        public List<String> getVerbs() {
            return this.verbs;
        }

        public void setVerbs(List<String> verbs) {
            this.verbs = verbs;
        }

        public List<String> getPrefixes() {
            return this.prefixes;
        }

        public void setPrefixes(List<String> prefixes) {
            this.prefixes = prefixes;
        }

        public Map<String, List<String>> getSuggestAlternatives() {
            return this.suggestAlternatives;
        }

        public void setSuggestAlternatives(Map<String, List<String>> suggestAlternatives) {
            this.suggestAlternatives = suggestAlternatives;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(StandardOperationVerbValidator.class, node -> {
                Config config = (Config)new NodeMapper().deserialize((Node)node, Config.class);
                if (config.getVerbs().isEmpty() && config.getSuggestAlternatives().isEmpty()) {
                    throw new SourceException("Either verbs or suggestAlternatives must be set when configuring StandardOperationVerb", (FromSourceLocation)node);
                }
                return new StandardOperationVerbValidator(config);
            });
        }
    }
}

