/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.AstModelLoader;
import software.amazon.smithy.model.loader.ForwardReferenceModelFile;
import software.amazon.smithy.model.loader.IdlNodeParser;
import software.amazon.smithy.model.loader.IdlTraitParser;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.StringUtils;

final class IdlModelParser
extends SimpleParser {
    private static final int MAX_NESTING_LEVEL = 250;
    private static final String PUT_KEY = "put";
    private static final String CREATE_KEY = "create";
    private static final String READ_KEY = "read";
    private static final String UPDATE_KEY = "update";
    private static final String DELETE_KEY = "delete";
    private static final String LIST_KEY = "list";
    private static final String RESOURCES_KEY = "resources";
    private static final String OPERATIONS_KEY = "operations";
    private static final String RENAME_KEY = "rename";
    private static final String COLLECTION_OPERATIONS_KEY = "collectionOperations";
    private static final String IDENTIFIERS_KEY = "identifiers";
    private static final String VERSION_KEY = "version";
    private static final String TYPE_KEY = "type";
    static final Collection<String> RESOURCE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "create", "read", "update", "delete", "list", "identifiers", "resources", "operations", "put", "collectionOperations"});
    static final List<String> SERVICE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "version", "operations", "resources", "rename"});
    private static final Collection<String> OPERATION_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"input", "output", "errors"});
    private static final Set<String> SHAPE_TYPES = new HashSet<String>();
    final ForwardReferenceModelFile modelFile;
    private final String filename;
    private String definedVersion;
    private TraitEntry pendingDocumentationComment;

    IdlModelParser(TraitFactory traitFactory, String filename, String model) {
        super(model, 250);
        this.filename = filename;
        this.modelFile = new ForwardReferenceModelFile(traitFactory);
    }

    ModelFile parse() {
        this.ws();
        this.parseControlSection();
        this.parseMetadataSection();
        this.parseShapeSection();
        return this.modelFile;
    }

    public void ws() {
        while (!this.eof()) {
            char c = this.peek();
            if (c == '/') {
                if (this.peekDocComment()) {
                    this.parseDocComment();
                    continue;
                }
                this.parseComment();
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            this.skip();
        }
    }

    public ModelSyntaxException syntax(String message) {
        String formatted = String.format("Parse error at line %d, column %d near `%s`: %s", this.line(), this.column(), this.peekDebugMessage(), message);
        return new ModelSyntaxException(formatted, this.filename, this.line(), this.column());
    }

    private void parseControlSection() {
        while (this.peek() == '$') {
            this.expect('$');
            this.ws();
            String key = IdlNodeParser.parseNodeObjectKey(this);
            this.ws();
            this.expect(':');
            this.ws();
            if (key.equals(VERSION_KEY) && this.definedVersion != null) {
                throw this.syntax("Cannot define multiple versions in the same file");
            }
            Node value = IdlNodeParser.parseNode(this);
            if (key.equals(VERSION_KEY)) {
                this.onVersion(value);
            } else {
                this.modelFile.events().add(ValidationEvent.builder().id("Model").sourceLocation(value).severity(Severity.WARNING).message(String.format("Unknown control statement `%s` with value `%s", key, Node.printJson(value))).build());
            }
            this.br();
            this.ws();
        }
    }

    private void onVersion(Node value) {
        String parsedVersion;
        if (!value.isStringNode()) {
            value.expectStringNode(() -> "The $version control statement must have a string value, but found " + Node.printJson(value));
        }
        if (!LoaderUtils.isVersionSupported(parsedVersion = value.expectStringNode().getValue())) {
            throw this.syntax("Unsupported Smithy version number: " + parsedVersion);
        }
        this.definedVersion = parsedVersion;
    }

    private void parseMetadataSection() {
        while (this.peek() == 'm') {
            this.expect('m');
            this.expect('e');
            this.expect('t');
            this.expect('a');
            this.expect('d');
            this.expect('a');
            this.expect('t');
            this.expect('a');
            this.ws();
            String key = IdlNodeParser.parseNodeObjectKey(this);
            this.ws();
            this.expect('=');
            this.ws();
            this.modelFile.putMetadata(key, IdlNodeParser.parseNode(this));
            this.br();
            this.ws();
        }
    }

    private void parseShapeSection() {
        if (this.peek() == 'n') {
            this.expect('n');
            this.expect('a');
            this.expect('m');
            this.expect('e');
            this.expect('s');
            this.expect('p');
            this.expect('a');
            this.expect('c');
            this.expect('e');
            this.ws();
            int start = this.position();
            ParserUtils.consumeNamespace(this);
            this.modelFile.setNamespace(this.sliceFrom(start));
            this.br();
            this.clearPendingDocs();
            this.ws();
            this.parseUseSection();
            this.parseShapeStatements();
        } else if (!this.eof()) {
            if (!ParserUtils.isIdentifierStart(this.peek())) {
                throw this.syntax("Expected a namespace definition, but found unexpected syntax");
            }
            throw this.syntax("A namespace must be defined before a use statement or shapes");
        }
    }

    private void parseUseSection() {
        while (this.peek() == 'u' && this.peek(1) == 's') {
            this.expect('u');
            this.expect('s');
            this.expect('e');
            this.ws();
            int start = this.position();
            SourceLocation location = this.currentLocation();
            ParserUtils.consumeNamespace(this);
            this.expect('#');
            ParserUtils.consumeIdentifier(this);
            String lexeme = this.sliceFrom(start);
            this.br();
            this.clearPendingDocs();
            this.ws();
            this.modelFile.useShape(ShapeId.from(lexeme), location);
        }
    }

    private void parseShapeStatements() {
        while (!this.eof()) {
            boolean docsOnly;
            this.ws();
            if (this.peek() == 'a') {
                this.parseApplyStatement();
                continue;
            }
            boolean bl = docsOnly = this.pendingDocumentationComment != null;
            List<TraitEntry> traits = this.parseDocsAndTraits();
            if (!this.parseShapeDefinition(traits, docsOnly)) continue;
            this.parseShape(traits);
        }
    }

    private void clearPendingDocs() {
        this.pendingDocumentationComment = null;
    }

    private boolean parseShapeDefinition(List<TraitEntry> traits, boolean docsOnly) {
        if (this.eof()) {
            return !traits.isEmpty() && !docsOnly;
        }
        return true;
    }

    private List<TraitEntry> parseDocsAndTraits() {
        TraitEntry docComment = this.pendingDocumentationComment;
        this.clearPendingDocs();
        this.ws();
        List<TraitEntry> traits = IdlTraitParser.parseTraits(this);
        if (docComment != null) {
            traits.add(docComment);
        }
        this.ws();
        return traits;
    }

    private void parseShape(List<TraitEntry> traits) {
        SourceLocation location = this.currentLocation();
        String shapeType = ParserUtils.parseIdentifier(this);
        if (!SHAPE_TYPES.contains(shapeType)) {
            switch (shapeType) {
                case "use": {
                    throw this.syntax("A use statement must come before any shape definition");
                }
                case "namespace": {
                    throw this.syntax("Only a single namespace can be declared per/file");
                }
                case "metadata": {
                    throw this.syntax("Metadata statements must appear before a namespace statement");
                }
            }
            throw this.syntax("Unexpected shape type: " + shapeType);
        }
        this.ws();
        ShapeId id = this.parseShapeName();
        switch (shapeType) {
            case "service": {
                this.parseServiceStatement(id, location);
                break;
            }
            case "resource": {
                this.parseResourceStatement(id, location);
                break;
            }
            case "operation": {
                this.parseOperationStatement(id, location);
                break;
            }
            case "structure": {
                this.parseStructuredShape(id, location, StructureShape.builder());
                break;
            }
            case "union": {
                this.parseStructuredShape(id, location, UnionShape.builder());
                break;
            }
            case "list": {
                this.parseCollection(id, location, ListShape.builder());
                break;
            }
            case "set": {
                this.parseCollection(id, location, SetShape.builder());
                break;
            }
            case "map": {
                this.parseMapStatement(id, location);
                break;
            }
            case "boolean": {
                this.parseSimpleShape(id, location, BooleanShape.builder());
                break;
            }
            case "string": {
                this.parseSimpleShape(id, location, StringShape.builder());
                break;
            }
            case "blob": {
                this.parseSimpleShape(id, location, BlobShape.builder());
                break;
            }
            case "byte": {
                this.parseSimpleShape(id, location, ByteShape.builder());
                break;
            }
            case "short": {
                this.parseSimpleShape(id, location, ShortShape.builder());
                break;
            }
            case "integer": {
                this.parseSimpleShape(id, location, IntegerShape.builder());
                break;
            }
            case "long": {
                this.parseSimpleShape(id, location, LongShape.builder());
                break;
            }
            case "float": {
                this.parseSimpleShape(id, location, FloatShape.builder());
                break;
            }
            case "document": {
                this.parseSimpleShape(id, location, DocumentShape.builder());
                break;
            }
            case "double": {
                this.parseSimpleShape(id, location, DoubleShape.builder());
                break;
            }
            case "bigInteger": {
                this.parseSimpleShape(id, location, BigIntegerShape.builder());
                break;
            }
            case "bigDecimal": {
                this.parseSimpleShape(id, location, BigDecimalShape.builder());
                break;
            }
            case "timestamp": {
                this.parseSimpleShape(id, location, TimestampShape.builder());
                break;
            }
            default: {
                throw this.syntax("Unexpected shape type: " + shapeType);
            }
        }
        this.addTraits(id, traits);
        this.clearPendingDocs();
        this.br();
    }

    private ShapeId parseShapeName() {
        String name = ParserUtils.parseIdentifier(this);
        return ShapeId.fromRelative(this.modelFile.namespace(), name);
    }

    private void parseSimpleShape(ShapeId id, SourceLocation location, AbstractShapeBuilder builder) {
        this.modelFile.onShape((AbstractShapeBuilder<?, ?>)((AbstractShapeBuilder)builder.source(location)).id(id));
    }

    private void parseCollection(ShapeId id, SourceLocation location, CollectionShape.Builder builder) {
        this.ws();
        builder.id(id).source(location);
        this.parseMembers(id, SetUtils.of((Object)"member"));
        this.modelFile.onShape(builder.id(id));
    }

    private void parseMembers(ShapeId id, Set<String> requiredMembers) {
        HashSet<String> definedMembers = new HashSet<String>();
        HashSet<String> remaining = requiredMembers.isEmpty() ? requiredMembers : new HashSet<String>(requiredMembers);
        this.ws();
        this.expect('{');
        this.clearPendingDocs();
        this.ws();
        if (this.peek() != '}') {
            this.parseMember(id, requiredMembers, definedMembers, remaining);
            while (!this.eof()) {
                this.ws();
                if (this.peek() != ',') break;
                this.expect(',');
                this.clearPendingDocs();
                this.ws();
                if (this.peek() == '}') break;
                this.parseMember(id, requiredMembers, definedMembers, remaining);
            }
        }
        if (!remaining.isEmpty()) {
            throw this.syntax("Missing required members of shape `" + id + "`: [" + ValidationUtils.tickedList(remaining) + ']');
        }
        this.expect('}');
    }

    private String parseMember(ShapeId parent, Set<String> required, Set<String> defined, Set<String> remaining) {
        List<TraitEntry> memberTraits = this.parseDocsAndTraits();
        SourceLocation memberLocation = this.currentLocation();
        String memberName = ParserUtils.parseIdentifier(this);
        if (defined.contains(memberName)) {
            throw this.syntax("Duplicate member of " + parent + ": '" + memberName + '\'');
        }
        defined.add(memberName);
        remaining.remove(memberName);
        if (!required.isEmpty() && !required.contains(memberName)) {
            throw this.syntax("Unexpected member of " + parent + ": '" + memberName + '\'');
        }
        this.ws();
        this.expect(':');
        this.ws();
        ShapeId memberId = parent.withMember(memberName);
        MemberShape.Builder memberBuilder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(memberId)).source(memberLocation);
        String target = ParserUtils.parseShapeId(this);
        this.modelFile.onShape(memberBuilder);
        this.modelFile.addForwardReference(target, memberBuilder::target);
        this.addTraits(memberId, memberTraits);
        return memberName;
    }

    private void parseMapStatement(ShapeId id, SourceLocation location) {
        this.parseMembers(id, SetUtils.of((Object[])new String[]{"key", "value"}));
        this.modelFile.onShape((AbstractShapeBuilder<?, ?>)MapShape.builder().id(id).source(location));
    }

    private void parseStructuredShape(ShapeId id, SourceLocation location, AbstractShapeBuilder builder) {
        this.modelFile.onShape((AbstractShapeBuilder<?, ?>)((AbstractShapeBuilder)builder.id(id)).source(location));
        this.parseMembers(id, Collections.emptySet());
    }

    private void parseOperationStatement(ShapeId id, SourceLocation location) {
        this.ws();
        OperationShape.Builder builder = (OperationShape.Builder)((OperationShape.Builder)OperationShape.builder().id(id)).source(location);
        ObjectNode node = IdlNodeParser.parseObjectNode(this, id.toString());
        LoaderUtils.checkForAdditionalProperties(node, id, OPERATION_PROPERTY_NAMES, this.modelFile.events());
        this.modelFile.onShape(builder);
        this.optionalId(node, "input", builder::input);
        this.optionalId(node, "output", builder::output);
        this.optionalIdList(node, "errors", builder::addError);
    }

    private void parseServiceStatement(ShapeId id, SourceLocation location) {
        this.ws();
        ServiceShape.Builder builder = (ServiceShape.Builder)((ServiceShape.Builder)new ServiceShape.Builder().id(id)).source(location);
        ObjectNode shapeNode = IdlNodeParser.parseObjectNode(this, id.toString());
        LoaderUtils.checkForAdditionalProperties(shapeNode, id, SERVICE_PROPERTY_NAMES, this.modelFile.events());
        builder.version(shapeNode.expectStringMember(VERSION_KEY).getValue());
        this.modelFile.onShape(builder);
        this.optionalIdList(shapeNode, OPERATIONS_KEY, builder::addOperation);
        this.optionalIdList(shapeNode, RESOURCES_KEY, builder::addResource);
        AstModelLoader.loadServiceRenameIntoBuilder(builder, shapeNode);
    }

    private void optionalId(ObjectNode node, String name, Consumer<ShapeId> consumer) {
        if (node.getMember(name).isPresent()) {
            this.modelFile.addForwardReference(node.expectStringMember(name).getValue(), consumer);
        }
    }

    private void optionalIdList(ObjectNode node, String name, Consumer<ShapeId> consumer) {
        if (node.getMember(name).isPresent()) {
            ArrayNode value = node.expectArrayMember(name);
            for (StringNode element : value.getElementsAs(StringNode.class)) {
                this.modelFile.addForwardReference(element.getValue(), consumer);
            }
        }
    }

    private void parseResourceStatement(ShapeId id, SourceLocation location) {
        this.ws();
        ResourceShape.Builder builder = (ResourceShape.Builder)((ResourceShape.Builder)ResourceShape.builder().id(id)).source(location);
        this.modelFile.onShape(builder);
        ObjectNode shapeNode = IdlNodeParser.parseObjectNode(this, id.toString());
        LoaderUtils.checkForAdditionalProperties(shapeNode, id, RESOURCE_PROPERTY_NAMES, this.modelFile.events());
        this.optionalId(shapeNode, PUT_KEY, builder::put);
        this.optionalId(shapeNode, CREATE_KEY, builder::create);
        this.optionalId(shapeNode, READ_KEY, builder::read);
        this.optionalId(shapeNode, UPDATE_KEY, builder::update);
        this.optionalId(shapeNode, DELETE_KEY, builder::delete);
        this.optionalId(shapeNode, LIST_KEY, builder::list);
        this.optionalIdList(shapeNode, OPERATIONS_KEY, builder::addOperation);
        this.optionalIdList(shapeNode, RESOURCES_KEY, builder::addResource);
        this.optionalIdList(shapeNode, COLLECTION_OPERATIONS_KEY, builder::addCollectionOperation);
        shapeNode.getObjectMember(IDENTIFIERS_KEY).ifPresent(ids -> {
            for (Map.Entry<StringNode, Node> entry : ids.getMembers().entrySet()) {
                String name = entry.getKey().getValue();
                StringNode target = entry.getValue().expectStringNode();
                this.modelFile.addForwardReference(target.getValue(), targetId -> builder.addIdentifier(name, (ToShapeId)targetId));
            }
        });
    }

    private void parseComment() {
        this.expect('/');
        this.consumeRemainingCharactersOnLine();
    }

    private void parseDocComment() {
        SourceLocation location = this.currentLocation();
        StringJoiner joiner = new StringJoiner("\n");
        do {
            joiner.add(this.parseDocCommentLine());
        } while (this.peekDocComment());
        this.pendingDocumentationComment = new TraitEntry(DocumentationTrait.ID.toString(), new StringNode(joiner.toString(), location), false);
    }

    private boolean peekDocComment() {
        return this.peek() == '/' && this.peek(1) == '/' && this.peek(2) == '/';
    }

    private String parseDocCommentLine() {
        this.expect('/');
        this.expect('/');
        this.expect('/');
        if (this.peek() == ' ') {
            this.skip();
        }
        int start = this.position();
        this.consumeRemainingCharactersOnLine();
        this.br();
        this.sp();
        return StringUtils.stripEnd((String)this.sliceFrom(start), (String)" \t\r\n");
    }

    private void parseApplyStatement() {
        this.expect('a');
        this.expect('p');
        this.expect('p');
        this.expect('l');
        this.expect('y');
        this.ws();
        String name = ParserUtils.parseShapeId(this);
        this.ws();
        TraitEntry traitEntry = IdlTraitParser.parseTraitValue(this);
        this.modelFile.addForwardReference(name, id -> this.onDeferredTrait((ShapeId)id, traitEntry.traitName, traitEntry.value, traitEntry.isAnnotation));
        this.clearPendingDocs();
        this.br();
        this.ws();
    }

    private void addTraits(ShapeId id, List<TraitEntry> traits) {
        for (TraitEntry traitEntry : traits) {
            this.onDeferredTrait(id, traitEntry.traitName, traitEntry.value, traitEntry.isAnnotation);
        }
    }

    private void onDeferredTrait(ShapeId target, String traitName, Node traitValue, boolean isAnnotation) {
        this.modelFile.addForwardReference(traitName, (id, typeProvider) -> this.modelFile.onTrait(target, (ShapeId)id, this.coerceTraitValue((ShapeId)id, traitValue, isAnnotation, (Function<ShapeId, ShapeType>)typeProvider)));
    }

    private Node coerceTraitValue(ShapeId traitId, Node value, boolean isAnnotation, Function<ShapeId, ShapeType> typeProvider) {
        if (isAnnotation && value.isNullNode()) {
            ShapeType targetType = typeProvider.apply(traitId);
            if (targetType == null || targetType == ShapeType.STRUCTURE || targetType == ShapeType.MAP) {
                return new ObjectNode(Collections.emptyMap(), value.getSourceLocation());
            }
            if (targetType == ShapeType.LIST || targetType == ShapeType.SET) {
                return new ArrayNode(Collections.emptyList(), value.getSourceLocation());
            }
        }
        return value;
    }

    SourceLocation currentLocation() {
        return new SourceLocation(this.filename, this.line(), this.column());
    }

    NumberNode parseNumberNode() {
        SourceLocation location = this.currentLocation();
        String lexeme = ParserUtils.parseNumber(this);
        if (lexeme.contains("e") || lexeme.contains("E") || lexeme.contains(".")) {
            double value = Double.parseDouble(lexeme);
            if (Double.isFinite(value)) {
                return new NumberNode(value, location);
            }
            return new NumberNode(new BigDecimal(lexeme), location);
        }
        try {
            return new NumberNode(Long.parseLong(lexeme), location);
        }
        catch (NumberFormatException e) {
            return new NumberNode(new BigInteger(lexeme), location);
        }
    }

    private String peekDebugMessage() {
        StringBuilder result = new StringBuilder(this.expression().length());
        char c = this.peek();
        if (c == ' ' || ParserUtils.isIdentifierStart(c) || ParserUtils.isDigit(c)) {
            int i;
            if (c == ' ') {
                result.append(' ');
            }
            int n = i = c == ' ' ? 1 : 0;
            while (i < 16 && (ParserUtils.isIdentifierStart(c = this.peek(i)) || ParserUtils.isDigit(c))) {
                result.append(c);
                ++i;
            }
            return result.toString();
        }
        for (int i = 0; i < 2; ++i) {
            char peek = this.peek(i);
            if (peek == '\u0000') {
                result.append("[EOF]");
                break;
            }
            result.append(peek);
        }
        return result.toString();
    }

    static {
        for (ShapeType type : ShapeType.values()) {
            if (type == ShapeType.MEMBER) continue;
            SHAPE_TYPES.add(type.toString());
        }
    }

    static final class TraitEntry {
        final String traitName;
        final Node value;
        final boolean isAnnotation;

        TraitEntry(String traitName, Node value, boolean isAnnotation) {
            this.traitName = traitName;
            this.value = value;
            this.isAnnotation = isAnnotation;
        }
    }
}

