/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Formatter;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;

public final class ContextualValidationEventFormatter
implements ValidationEventFormatter {
    @Override
    public String format(ValidationEvent event) {
        StringWriter writer = new StringWriter();
        Formatter formatter = new Formatter(writer);
        formatter.format("%s: %s (%s)%n", new Object[]{event.getSeverity(), event.getShapeId().map(ShapeId::toString).orElse("-"), event.getId()});
        if (event.getSourceLocation() != SourceLocation.NONE) {
            String humanReadableFilename = this.getHumanReadableFilename(event.getSourceLocation());
            String contextualLine = null;
            try {
                contextualLine = this.loadContextualLine(event.getSourceLocation());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (contextualLine == null) {
                formatter.format("     @ %s%n", event.getSourceLocation());
            } else {
                formatter.format("     @ %s%n", humanReadableFilename);
                formatter.format("     |%n", new Object[0]);
                formatter.format("%4d | %s%n", event.getSourceLocation().getLine(), contextualLine);
                formatter.format("     | %" + event.getSourceLocation().getColumn() + "s%n", "^");
            }
        }
        formatter.format("     = %s%n", event.getMessage().replace("\n", "       \n"));
        formatter.flush();
        return writer.toString();
    }

    private String getHumanReadableFilename(SourceLocation source) {
        String filename = source.getFilename();
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        return filename;
    }

    /*
     * Exception decompiling
     */
    private String loadContextualLine(SourceLocation source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

