/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ObjectNode
extends Node
implements ToSmithyBuilder<ObjectNode> {
    static final ObjectNode EMPTY = new ObjectNode(MapUtils.of(), SourceLocation.none(), false);
    private static final Logger LOGGER = Logger.getLogger(ObjectNode.class.getName());
    private final Map<StringNode, Node> nodeMap;
    private transient Map<String, Node> stringMap;

    public ObjectNode(Map<StringNode, Node> members, SourceLocation sourceLocation) {
        this(members, sourceLocation, true);
    }

    ObjectNode(Map<StringNode, Node> nodeMap, SourceLocation sourceLocation, boolean defensiveCopy) {
        super(sourceLocation);
        this.nodeMap = defensiveCopy ? Collections.unmodifiableMap(new LinkedHashMap<StringNode, Node>(nodeMap)) : Collections.unmodifiableMap(nodeMap);
    }

    private ObjectNode(Builder builder) {
        super(builder.sourceLocation);
        this.nodeMap = (Map)builder.nodeMap.copy();
    }

    public static ObjectNode fromStringMap(Map<String, String> map) {
        return map.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, e -> ObjectNode.from((String)e.getValue())));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public NodeType getType() {
        return NodeType.OBJECT;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.objectNode(this);
    }

    @Override
    public ObjectNode expectObjectNode(String errorMessage) {
        return this;
    }

    @Override
    public ObjectNode expectObjectNode(Supplier<String> errorMessage) {
        return this;
    }

    @Override
    public Optional<ObjectNode> asObjectNode() {
        return Optional.of(this);
    }

    public <T extends ToNode> ObjectNode withMember(StringNode key, T value) {
        LinkedHashMap<StringNode, Node> nodeMapCopy = new LinkedHashMap<StringNode, Node>(this.nodeMap);
        nodeMapCopy.put(Objects.requireNonNull(key), Objects.requireNonNull(value).toNode());
        return new ObjectNode(nodeMapCopy, this.getSourceLocation(), false);
    }

    public <T extends ToNode> ObjectNode withMember(String key, T value) {
        return this.withMember(ObjectNode.from(key), value);
    }

    public ObjectNode withMember(String key, String value) {
        return this.withMember(ObjectNode.from(key), ObjectNode.from(value));
    }

    public ObjectNode withMember(String key, boolean value) {
        return this.withMember(ObjectNode.from(key), ObjectNode.from(value));
    }

    public ObjectNode withMember(String key, Number value) {
        return this.withMember(ObjectNode.from(key), ObjectNode.from(value));
    }

    public <T extends ToNode> ObjectNode withOptionalMember(String key, Optional<T> value) {
        return value.map(val -> this.withMember(key, val)).orElse(this);
    }

    public ObjectNode withoutMember(String memberName) {
        if (!this.getStringMap().containsKey(memberName)) {
            return this;
        }
        LinkedHashMap<StringNode, Node> copiedMembers = new LinkedHashMap<StringNode, Node>(this.nodeMap);
        copiedMembers.keySet().removeIf(k -> k.getValue().equals(memberName));
        return new ObjectNode(copiedMembers, this.getSourceLocation(), false);
    }

    public Map<StringNode, Node> getMembers() {
        return this.nodeMap;
    }

    public boolean containsMember(String memberName) {
        return this.getStringMap().containsKey(memberName);
    }

    public Optional<Node> getMember(String memberName) {
        return Optional.ofNullable(this.getStringMap().get(memberName));
    }

    public Map<String, Node> getMembersByPrefix(String prefix) {
        return this.getStringMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Node> getStringMap() {
        Map<String, Node> map = this.stringMap;
        if (map == null) {
            map = new LinkedHashMap<String, Node>(this.nodeMap.size());
            for (Map.Entry<StringNode, Node> entry : this.nodeMap.entrySet()) {
                map.put(entry.getKey().getValue(), entry.getValue());
            }
            this.stringMap = Collections.unmodifiableMap(map);
        }
        return this.stringMap;
    }

    public Optional<StringNode> getStringMember(String memberName) {
        return this.getMember(memberName).map(n -> n.expectStringNode(() -> String.format("Expected `%s` to be a string; found {type}", memberName)));
    }

    public String getStringMemberOrDefault(String memberName, String defaultValue) {
        return this.getStringMember(memberName).map(StringNode::getValue).orElse(defaultValue);
    }

    public Optional<NumberNode> getNumberMember(String memberName) {
        return this.getMember(memberName).map(n -> n.expectNumberNode(() -> String.format("Expected `%s` to be a number; found {type}", memberName)));
    }

    public Number getNumberMemberOrDefault(String memberName, Number defaultValue) {
        return this.getNumberMember(memberName).map(NumberNode::getValue).orElse(defaultValue);
    }

    public Optional<ArrayNode> getArrayMember(String memberName) {
        return this.getMember(memberName).map(n -> n.expectArrayNode(() -> String.format("Expected `%s` to be an array; found {type}", memberName)));
    }

    public Optional<ObjectNode> getObjectMember(String memberName) {
        return this.getMember(memberName).map(n -> n.expectObjectNode(() -> String.format("Expected `%s` to be an object; found {type}", memberName)));
    }

    public Optional<BooleanNode> getBooleanMember(String memberName) {
        return this.getMember(memberName).map(n -> n.expectBooleanNode(() -> String.format("Expected `%s` to be a boolean; found {type}", memberName)));
    }

    public Boolean getBooleanMemberOrDefault(String memberName, Boolean defaultValue) {
        return this.getBooleanMember(memberName).map(BooleanNode::getValue).orElse(defaultValue);
    }

    public boolean getBooleanMemberOrDefault(String memberName) {
        return this.getBooleanMemberOrDefault(memberName, false);
    }

    public Node expectMember(String name) {
        return this.expectMember(name, () -> String.format("Missing expected member `%s`.", name));
    }

    public Node expectMember(String name, String errorMessage) {
        return this.getMember(name).orElseThrow(() -> new ExpectationNotMetException(errorMessage, this));
    }

    public Node expectMember(String name, Supplier<String> errorMessage) {
        return this.getMember(name).orElseThrow(() -> new ExpectationNotMetException((String)errorMessage.get(), this));
    }

    public ArrayNode expectArrayMember(String name) {
        return this.expectMember(name).expectArrayNode(() -> String.format("Expected `%s` member to be an array, but found {type}.", name));
    }

    public BooleanNode expectBooleanMember(String name) {
        return this.expectMember(name).expectBooleanNode(() -> String.format("Expected `%s` member to be a boolean, but found {type}.", name));
    }

    public NullNode expectNullMember(String name) {
        return this.expectMember(name).expectNullNode(() -> String.format("Expected `%s` member to be null, but found {type}.", name));
    }

    public NumberNode expectNumberMember(String name) {
        return this.expectMember(name).expectNumberNode(() -> String.format("Expected `%s` member to be a number, but found {type}.", name));
    }

    public ObjectNode expectObjectMember(String name) {
        return this.expectMember(name).expectObjectNode(() -> String.format("Expected `%s` member to be an object, but found {type}.", name));
    }

    public StringNode expectStringMember(String name) {
        return this.expectMember(name).expectStringNode(() -> String.format("Expected `%s` member to be a string, but found {type}.", name));
    }

    public ObjectNode expectNoAdditionalProperties(Collection<String> allowedProperties) {
        for (String key : this.getStringMap().keySet()) {
            if (allowedProperties.contains(key)) continue;
            HashSet<String> additional = new HashSet<String>(this.getStringMap().keySet());
            additional.removeAll(allowedProperties);
            throw new ExpectationNotMetException(String.format("Expected an object with possible properties of %s, but found additional properties: %s", ValidationUtils.tickedList(allowedProperties), ValidationUtils.tickedList(additional)), this);
        }
        return this;
    }

    public ObjectNode warnIfAdditionalProperties(Collection<String> allowedProperties) {
        try {
            this.expectNoAdditionalProperties(allowedProperties);
        }
        catch (ExpectationNotMetException e) {
            LOGGER.warning(e.getMessage() + " (" + this.getSourceLocation() + ")");
        }
        return this;
    }

    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    public int size() {
        return this.nodeMap.size();
    }

    public ObjectNode merge(ObjectNode other) {
        LinkedHashMap<StringNode, Node> result = new LinkedHashMap<StringNode, Node>(this.getMembers());
        result.putAll(other.nodeMap);
        return new ObjectNode(result, this.getSourceLocation() != SourceLocation.NONE ? this.getSourceLocation() : other.getSourceLocation(), false);
    }

    public static <T> Collector<T, Map<StringNode, Node>, ObjectNode> collect(Function<T, StringNode> keyMapper, Function<T, ToNode> valueMapper) {
        return Collector.of(LinkedHashMap::new, (results, entry) -> results.put((StringNode)keyMapper.apply(entry), ((ToNode)valueMapper.apply(entry)).toNode()), (left, right) -> {
            left.putAll(right);
            return left;
        }, results -> new ObjectNode((Map<StringNode, Node>)results, SourceLocation.NONE, false), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, Map<StringNode, Node>, ObjectNode> collectStringKeys(Function<T, String> keyMapper, Function<T, ToNode> valueMapper) {
        return ObjectNode.collect(entry -> ObjectNode.from((String)keyMapper.apply(entry)), valueMapper);
    }

    public boolean equals(Object other) {
        return other instanceof ObjectNode && this.nodeMap.equals(((ObjectNode)other).nodeMap);
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + this.nodeMap.hashCode();
    }

    public Builder toBuilder() {
        return new Builder().merge(this);
    }

    public static final class Builder
    implements SmithyBuilder<ObjectNode> {
        private final BuilderRef<Map<StringNode, Node>> nodeMap = BuilderRef.forOrderedMap();
        private SourceLocation sourceLocation = SourceLocation.NONE;

        Builder() {
        }

        public ObjectNode build() {
            return new ObjectNode(this);
        }

        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = Objects.requireNonNull(sourceLocation);
            return this;
        }

        public boolean hasMember(String key) {
            if (this.nodeMap.hasValue()) {
                for (StringNode k : ((Map)this.nodeMap.peek()).keySet()) {
                    if (!key.equals(k.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        public <T extends ToNode> Builder withMember(StringNode key, T value) {
            ((Map)this.nodeMap.get()).put(key, value.toNode());
            return this;
        }

        public <T extends ToNode> Builder withMember(String key, T value) {
            return this.withMember(Node.from(key), value.toNode());
        }

        public Builder withMember(String key, String value) {
            return this.withMember(Node.from(key), Node.from(value));
        }

        public Builder withMember(String key, boolean value) {
            return this.withMember(Node.from(key), Node.from(value));
        }

        public Builder withMember(String key, Number value) {
            return this.withMember(Node.from(key), Node.from(value));
        }

        public <T extends ToNode> Builder withOptionalMember(String key, Optional<T> value) {
            return value.map(val -> this.withMember(key, val.toNode())).orElse(this);
        }

        public Builder withoutMember(String memberName) {
            ((Map)this.nodeMap.get()).keySet().removeIf(key -> key.getValue().equals(memberName));
            return this;
        }

        public Builder merge(ObjectNode other) {
            for (Map.Entry<StringNode, Node> entry : other.getMembers().entrySet()) {
                ((Map)this.nodeMap.get()).put(entry.getKey(), entry.getValue());
            }
            return this;
        }
    }
}

