/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.AttributeValueImpl;

@FunctionalInterface
interface AttributeComparator {
    public static final AttributeComparator EQUALS = AttributeComparator.stringComparator(String::equals);
    public static final AttributeComparator NOT_EQUALS = AttributeComparator.stringComparator((a, b) -> !a.equals(b));
    public static final AttributeComparator STARTS_WITH = AttributeComparator.stringComparator(String::startsWith);
    public static final AttributeComparator ENDS_WITH = AttributeComparator.stringComparator(String::endsWith);
    public static final AttributeComparator CONTAINS = AttributeComparator.stringComparator(String::contains);
    public static final AttributeComparator GT = AttributeComparator.numericComparator(result -> result == 1);
    public static final AttributeComparator GTE = AttributeComparator.numericComparator(result -> result >= 0);
    public static final AttributeComparator LT = AttributeComparator.numericComparator(result -> result <= -1);
    public static final AttributeComparator LTE = AttributeComparator.numericComparator(result -> result <= 0);
    public static final AttributeComparator EXISTS = AttributeComparator::existsCheck;
    public static final AttributeComparator SUBSET = AttributeComparator::subset;
    public static final AttributeComparator PROPER_SUBSET = AttributeComparator::properSubset;
    public static final AttributeComparator PROJECTION_EQUALS = AttributeComparator::setEquals;
    public static final AttributeComparator PROJECTION_NOT_EQUALS = AttributeComparator::setNotEquals;

    public boolean compare(AttributeValue var1, AttributeValue var2, boolean var3);

    public static AttributeComparator flattenedCompare(AttributeComparator singleComparison) {
        return (lhs, rhs, caseInsensitive) -> {
            for (AttributeValue attributeValue : lhs.getFlattenedValues()) {
                for (AttributeValue attributeValue2 : rhs.getFlattenedValues()) {
                    if (!singleComparison.compare(attributeValue, attributeValue2, caseInsensitive)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static AttributeComparator stringComparator(BiFunction<String, String, Boolean> compare) {
        return AttributeComparator.flattenedCompare((lhs, rhs, caseInsensitive) -> {
            if (!lhs.isPresent() || !rhs.isPresent()) {
                return false;
            }
            String lhsString = lhs.toString();
            String rhsString = rhs.toString();
            if (caseInsensitive) {
                lhsString = lhsString.toLowerCase(Locale.ENGLISH);
                rhsString = rhsString.toLowerCase(Locale.ENGLISH);
            }
            return (Boolean)compare.apply(lhsString, rhsString);
        });
    }

    public static AttributeComparator numericComparator(Function<Integer, Boolean> evaluator) {
        return AttributeComparator.stringComparator((lhs, rhs) -> {
            BigDecimal lhsNumber = AttributeComparator.parseNumber(lhs);
            if (lhsNumber == null) {
                return false;
            }
            BigDecimal rhsNumber = AttributeComparator.parseNumber(rhs);
            if (rhsNumber == null) {
                return false;
            }
            return (Boolean)evaluator.apply(lhsNumber.compareTo(rhsNumber));
        });
    }

    public static BigDecimal parseNumber(String token) {
        try {
            return new BigDecimal(token);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean existsCheck(AttributeValue a, AttributeValue b, boolean caseInsensitive) {
        String bString = b.toString();
        return a.isPresent() && bString.equals("true") || !a.isPresent() && b.toString().equals("false");
    }

    public static boolean areBothProjections(AttributeValue a, AttributeValue b) {
        return a instanceof AttributeValueImpl.Projection && b instanceof AttributeValueImpl.Projection;
    }

    public static boolean subset(AttributeValue a, AttributeValue b, boolean caseInsensitive) {
        return AttributeComparator.areBothProjections(a, b) && AttributeComparator.isSubset(a.getFlattenedValues(), b.getFlattenedValues(), caseInsensitive);
    }

    public static boolean isSubset(Collection<? extends AttributeValue> aValues, Collection<? extends AttributeValue> bValues, boolean caseInsensitive) {
        for (AttributeValue attributeValue : aValues) {
            boolean foundMatch = false;
            for (AttributeValue attributeValue2 : bValues) {
                if (!EQUALS.compare(attributeValue, attributeValue2, caseInsensitive)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public static boolean properSubset(AttributeValue a, AttributeValue b, boolean caseInsensitive) {
        Collection<? extends AttributeValue> bValues;
        if (!AttributeComparator.areBothProjections(a, b)) {
            return false;
        }
        Collection<? extends AttributeValue> aValues = a.getFlattenedValues();
        return AttributeComparator.isSubset(aValues, bValues = b.getFlattenedValues(), caseInsensitive) && !AttributeComparator.isSubset(bValues, aValues, caseInsensitive);
    }

    public static boolean setEquals(AttributeValue a, AttributeValue b, boolean caseInsensitive) {
        Collection<? extends AttributeValue> bValues;
        if (!AttributeComparator.areBothProjections(a, b)) {
            return false;
        }
        Collection<? extends AttributeValue> aValues = a.getFlattenedValues();
        return AttributeComparator.isSubset(aValues, bValues = b.getFlattenedValues(), caseInsensitive) && AttributeComparator.isSubset(bValues, aValues, caseInsensitive);
    }

    public static boolean setNotEquals(AttributeValue a, AttributeValue b, boolean caseInsensitive) {
        return !AttributeComparator.setEquals(a, b, caseInsensitive);
    }
}

