/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Optional;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;

public enum ShapeType {
    BLOB("blob", BlobShape.class, Category.SIMPLE),
    BOOLEAN("boolean", BooleanShape.class, Category.SIMPLE),
    STRING("string", StringShape.class, Category.SIMPLE),
    TIMESTAMP("timestamp", TimestampShape.class, Category.SIMPLE),
    BYTE("byte", ByteShape.class, Category.SIMPLE),
    SHORT("short", ShortShape.class, Category.SIMPLE),
    INTEGER("integer", IntegerShape.class, Category.SIMPLE),
    LONG("long", LongShape.class, Category.SIMPLE),
    FLOAT("float", FloatShape.class, Category.SIMPLE),
    DOCUMENT("document", DocumentShape.class, Category.SIMPLE),
    DOUBLE("double", DoubleShape.class, Category.SIMPLE),
    BIG_DECIMAL("bigDecimal", BigDecimalShape.class, Category.SIMPLE),
    BIG_INTEGER("bigInteger", BigIntegerShape.class, Category.SIMPLE),
    LIST("list", ListShape.class, Category.AGGREGATE),
    SET("set", SetShape.class, Category.AGGREGATE),
    MAP("map", MapShape.class, Category.AGGREGATE),
    STRUCTURE("structure", StructureShape.class, Category.AGGREGATE),
    UNION("union", UnionShape.class, Category.AGGREGATE),
    MEMBER("member", MemberShape.class, Category.AGGREGATE),
    SERVICE("service", ServiceShape.class, Category.SERVICE),
    RESOURCE("resource", ResourceShape.class, Category.SERVICE),
    OPERATION("operation", OperationShape.class, Category.SERVICE);

    private final String stringValue;
    private final Class<? extends Shape> shapeClass;
    private final Category category;

    private ShapeType(String stringValue, Class<? extends Shape> shapeClass, Category categry) {
        this.stringValue = stringValue;
        this.shapeClass = shapeClass;
        this.category = categry;
    }

    public String toString() {
        return this.stringValue;
    }

    public Class<? extends Shape> getShapeClass() {
        return this.shapeClass;
    }

    public Category getCategory() {
        return this.category;
    }

    public static Optional<ShapeType> fromString(String text) {
        for (ShapeType e : ShapeType.values()) {
            if (!e.stringValue.equals(text)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public AbstractShapeBuilder<?, ?> createBuilderForType() {
        switch (this) {
            case BLOB: {
                return BlobShape.builder();
            }
            case BOOLEAN: {
                return BooleanShape.builder();
            }
            case STRING: {
                return StringShape.builder();
            }
            case TIMESTAMP: {
                return TimestampShape.builder();
            }
            case BYTE: {
                return ByteShape.builder();
            }
            case SHORT: {
                return ShortShape.builder();
            }
            case INTEGER: {
                return IntegerShape.builder();
            }
            case LONG: {
                return LongShape.builder();
            }
            case FLOAT: {
                return FloatShape.builder();
            }
            case DOCUMENT: {
                return DocumentShape.builder();
            }
            case DOUBLE: {
                return DoubleShape.builder();
            }
            case BIG_DECIMAL: {
                return BigDecimalShape.builder();
            }
            case BIG_INTEGER: {
                return BigIntegerShape.builder();
            }
            case LIST: {
                return ListShape.builder();
            }
            case SET: {
                return SetShape.builder();
            }
            case MAP: {
                return MapShape.builder();
            }
            case STRUCTURE: {
                return StructureShape.builder();
            }
            case UNION: {
                return UnionShape.builder();
            }
            case SERVICE: {
                return ServiceShape.builder();
            }
            case RESOURCE: {
                return ResourceShape.builder();
            }
            case OPERATION: {
                return OperationShape.builder();
            }
            case MEMBER: {
                return MemberShape.builder();
            }
        }
        throw new IllegalStateException("Invalid shape type: " + (Object)((Object)this));
    }

    public static enum Category {
        SIMPLE,
        AGGREGATE,
        SERVICE;

    }
}

