/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.model.validation.node.TimestampFormatPlugin;

public enum TimestampValidationStrategy implements NodeValidatorPlugin
{
    FORMAT{

        @Override
        public void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
            new TimestampFormatPlugin().apply(shape, value, context, emitter);
        }
    }
    ,
    EPOCH_SECONDS{

        @Override
        public void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
            if (TimestampValidationStrategy.isTimestampMember(context.model(), shape) && !value.isNumberNode()) {
                emitter.accept(shape, "Invalid " + (Object)((Object)value.getType()) + " value provided for timestamp, `" + shape.getId() + "`. Expected a number that contains epoch seconds with optional millisecond precision");
            }
        }
    };


    private static boolean isTimestampMember(Model model, Shape shape) {
        return shape.asMemberShape().map(MemberShape::getTarget).flatMap(model::getShape).filter(Shape::isTimestampShape).isPresent();
    }
}

