/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.suppressions;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.SuppressTrait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.suppressions.MetadataSuppression;
import software.amazon.smithy.model.validation.suppressions.TraitSuppression;

@FunctionalInterface
public interface Suppression {
    public boolean test(ValidationEvent var1);

    default public Optional<String> getReason() {
        return Optional.empty();
    }

    public static Suppression fromSuppressTrait(Shape shape) {
        return new TraitSuppression(shape.getId(), shape.expectTrait(SuppressTrait.class));
    }

    public static Suppression fromMetadata(Node node) {
        return MetadataSuppression.fromNode(node);
    }
}

