/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceShape
extends EntityShape
implements ToSmithyBuilder<ServiceShape> {
    private final String version;
    private final Map<ShapeId, String> rename;
    private final List<ShapeId> errors;

    private ServiceShape(Builder builder) {
        super(builder);
        this.version = builder.version;
        this.rename = (Map)builder.rename.copy();
        this.errors = (List)builder.errors.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)ServiceShape.builder().from(this)).version(this.version).errors(this.errors).rename(this.rename).operations(this.getOperations())).resources(this.getResources());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.serviceShape(this);
    }

    @Override
    public Optional<ServiceShape> asServiceShape() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        ServiceShape o = (ServiceShape)other;
        return this.version.equals(o.version) && this.rename.equals(o.rename) && this.errors.equals(o.errors);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.SERVICE;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<ShapeId, String> getRename() {
        return this.rename;
    }

    public List<ShapeId> getErrors() {
        return this.errors;
    }

    public String getContextualName(ToShapeId shape) {
        ShapeId id = shape.toShapeId();
        return this.rename.getOrDefault(id, id.getName());
    }

    public static final class Builder
    extends EntityShape.Builder<Builder, ServiceShape> {
        private String version = "";
        private final BuilderRef<Map<ShapeId, String>> rename = BuilderRef.forOrderedMap();
        private final BuilderRef<List<ShapeId>> errors = BuilderRef.forList();

        public ServiceShape build() {
            return new ServiceShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.SERVICE;
        }

        public Builder version(String version) {
            this.version = version == null ? "" : version;
            return this;
        }

        public Builder clearRename() {
            this.rename.clear();
            return this;
        }

        public Builder rename(Map<ShapeId, String> rename) {
            this.clearRename();
            rename.forEach(this::putRename);
            return this;
        }

        public Builder putRename(ShapeId from, String to) {
            ((Map)this.rename.get()).put(Objects.requireNonNull(from), Objects.requireNonNull(to));
            return this;
        }

        public Builder removeRename(ToShapeId from) {
            ((Map)this.rename.get()).remove(from.toShapeId());
            return this;
        }

        public Builder errors(Collection<ShapeId> errorShapeIds) {
            this.errors.clear();
            errorShapeIds.forEach(this::addError);
            return this;
        }

        public Builder addError(ToShapeId errorShapeId) {
            ((List)this.errors.get()).add(errorShapeId.toShapeId());
            return this;
        }

        public Builder addError(String errorShapeId) {
            return this.addError(ShapeId.from(errorShapeId));
        }

        public Builder addErrors(List<ShapeId> errorShapeIds) {
            ((List)this.errors.get()).addAll((Collection)Objects.requireNonNull(errorShapeIds));
            return this;
        }

        public Builder removeError(ToShapeId errorShapeId) {
            ((List)this.errors.get()).remove(errorShapeId.toShapeId());
            return this;
        }

        public Builder clearErrors() {
            this.errors.clear();
            return this;
        }
    }
}

