/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.linters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SimpleParser;

public final class EmitEachSelectorValidator
extends AbstractValidator {
    private final Config config;

    public EmitEachSelectorValidator(Config config) {
        this.config = config;
        Objects.requireNonNull(config.selector, "selector is required");
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        if (this.config.bindToTrait != null && !model.getAppliedTraits().contains(this.config.getBindToTrait())) {
            return Collections.emptyList();
        }
        if (this.config.messageTemplate == null) {
            return this.validateWithSimpleMessages(model);
        }
        return this.validateWithTemplate(model);
    }

    private List<ValidationEvent> validateWithSimpleMessages(Model model) {
        return this.config.getSelector().select(model).stream().flatMap(shape -> OptionalUtils.stream(this.createSimpleEvent((Shape)shape))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> createSimpleEvent(Shape shape) {
        FromSourceLocation location = this.determineEventLocation(shape);
        if (location == null) {
            return Optional.empty();
        }
        return Optional.of(this.danger(shape, location, "Selector capture matched selector: " + this.config.getSelector()));
    }

    private FromSourceLocation determineEventLocation(Shape shape) {
        return this.config.bindToTrait == null ? shape.getSourceLocation() : (FromSourceLocation)shape.findTrait(this.config.bindToTrait).orElse(null);
    }

    private List<ValidationEvent> validateWithTemplate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.config.getSelector().consumeMatches(model, match -> this.createTemplatedEvent((Selector.ShapeMatch)match).ifPresent(events::add));
        return events;
    }

    private Optional<ValidationEvent> createTemplatedEvent(Selector.ShapeMatch match) {
        FromSourceLocation location = this.determineEventLocation(match.getShape());
        if (location == null) {
            return Optional.empty();
        }
        AttributeValue value = AttributeValue.shape(match.getShape(), match);
        return Optional.of(this.danger(match.getShape(), location, this.config.messageTemplate.expand(value)));
    }

    public static final class Config {
        private Selector selector;
        private ShapeId bindToTrait;
        private MessageTemplate messageTemplate;

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }

        public ShapeId getBindToTrait() {
            return this.bindToTrait;
        }

        public void setBindToTrait(ShapeId bindToTrait) {
            this.bindToTrait = bindToTrait;
        }

        public String getMessageTemplate() {
            return this.messageTemplate == null ? null : this.messageTemplate.toString();
        }

        public void setMessageTemplate(String messageTemplate) {
            this.messageTemplate = new MessageTemplateParser(messageTemplate).parse();
        }
    }

    private static final class MessageTemplate {
        private final String template;
        private final List<Function<AttributeValue, String>> parts;

        private MessageTemplate(String template, List<Function<AttributeValue, String>> parts) {
            this.template = template;
            this.parts = parts;
        }

        private String expand(AttributeValue value) {
            StringBuilder builder = new StringBuilder();
            for (Function<AttributeValue, String> part : this.parts) {
                builder.append(part.apply(value));
            }
            return builder.toString();
        }

        public String toString() {
            return this.template;
        }
    }

    private static final class MessageTemplateParser
    extends SimpleParser {
        private int mark = 0;
        private final List<Function<AttributeValue, String>> parts = new ArrayList<Function<AttributeValue, String>>();

        private MessageTemplateParser(String expression) {
            super(expression);
        }

        MessageTemplate parse() {
            while (!this.eof()) {
                this.consumeUntilNoLongerMatches(c -> c.charValue() != '@');
                if (this.peek(1) == '@') {
                    this.skip();
                    this.addLiteralPartIfNecessary();
                    this.skip();
                    ++this.mark;
                    continue;
                }
                if (this.eof()) continue;
                this.addLiteralPartIfNecessary();
                List<String> path = AttributeValue.parseScopedAttribute(this);
                this.parts.add(attributeValue -> attributeValue.getPath(path).toMessageString());
                this.mark = this.position();
            }
            this.addLiteralPartIfNecessary();
            return new MessageTemplate(this.expression(), this.parts);
        }

        public RuntimeException syntax(String message) {
            return new RuntimeException("Syntax error at line " + this.line() + " column " + this.column() + " of EmitEachSelector message template: " + message);
        }

        private void addLiteralPartIfNecessary() {
            String slice = this.sliceFrom(this.mark);
            if (!slice.isEmpty()) {
                this.parts.add(ignoredAttribute -> slice);
            }
            this.mark = this.position();
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(EmitEachSelectorValidator.class, (ObjectNode configuration) -> {
                NodeMapper mapper = new NodeMapper();
                Config config = mapper.deserialize((Node)configuration, Config.class);
                return new EmitEachSelectorValidator(config);
            });
        }
    }
}

