/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlModelParser;
import software.amazon.smithy.model.loader.IdlNodeParser;
import software.amazon.smithy.model.loader.IdlTextParser;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;

final class IdlTraitParser {
    private IdlTraitParser() {
    }

    static List<IdlModelParser.TraitEntry> parseTraits(IdlModelParser parser) {
        ArrayList<IdlModelParser.TraitEntry> entries = new ArrayList<IdlModelParser.TraitEntry>();
        while (parser.peek() == '@') {
            entries.add(IdlTraitParser.parseTraitValue(parser));
            parser.ws();
        }
        return entries;
    }

    static IdlModelParser.TraitEntry parseTraitValue(IdlModelParser parser) {
        SourceLocation location = parser.currentLocation();
        parser.expect('@');
        String id = ParserUtils.parseShapeId(parser);
        if (parser.peek() != '(') {
            return new IdlModelParser.TraitEntry(id, new NullNode(location), true);
        }
        parser.expect('(');
        parser.ws();
        if (parser.peek() == ')') {
            parser.expect(')');
            return new IdlModelParser.TraitEntry(id, new NullNode(location), true);
        }
        Node value = IdlTraitParser.parseTraitValueBody(parser, location);
        parser.ws();
        parser.expect(')');
        return new IdlModelParser.TraitEntry(id, value, false);
    }

    private static Node parseTraitValueBody(IdlModelParser parser, SourceLocation location) {
        char c = parser.peek();
        switch (c) {
            case '[': 
            case '{': {
                return IdlNodeParser.parseNode(parser, location);
            }
            case '\"': {
                if (IdlNodeParser.peekTextBlock(parser)) {
                    return IdlNodeParser.parseTextBlock(parser, location);
                }
                String key = IdlTextParser.parseQuotedString(parser);
                return IdlTraitParser.parseTraitValueBodyIdentifierOrQuotedString(parser, location, key, false);
            }
        }
        if (c == '-' || ParserUtils.isDigit(c)) {
            return parser.parseNumberNode(location);
        }
        String key = ParserUtils.parseIdentifier(parser);
        return IdlTraitParser.parseTraitValueBodyIdentifierOrQuotedString(parser, location, key, true);
    }

    private static Node parseTraitValueBodyIdentifierOrQuotedString(IdlModelParser parser, SourceLocation location, String key, boolean unquoted) {
        parser.ws();
        if (parser.peek() == ':') {
            parser.expect(':');
            parser.ws();
            return IdlTraitParser.parseStructuredTrait(parser, new StringNode(key, location));
        }
        if (unquoted) {
            return IdlNodeParser.parseNodeTextWithKeywords(parser, location, key);
        }
        return new StringNode(key, location);
    }

    private static ObjectNode parseStructuredTrait(IdlModelParser parser, StringNode startingKey) {
        LinkedHashMap<StringNode, Node> entries = new LinkedHashMap<StringNode, Node>();
        Node firstValue = IdlNodeParser.parseNode(parser);
        entries.put(startingKey, firstValue);
        parser.ws();
        while (!parser.eof() && parser.peek() != ')') {
            char c = parser.peek();
            if (ParserUtils.isIdentifierStart(c) || c == '\"') {
                IdlTraitParser.parseTraitStructureKvp(parser, entries);
                continue;
            }
            throw parser.syntax("Unexpected object key character: '" + c + '\'');
        }
        return new ObjectNode(entries, startingKey.getSourceLocation());
    }

    private static void parseTraitStructureKvp(IdlModelParser parser, Map<StringNode, Node> entries) {
        SourceLocation keyLocation = parser.currentLocation();
        String key = IdlNodeParser.parseNodeObjectKey(parser);
        StringNode nextKey = new StringNode(key, keyLocation);
        parser.ws();
        parser.expect(':');
        parser.ws();
        Node nextValue = IdlNodeParser.parseNode(parser);
        parser.ws();
        Node previous = entries.put(nextKey, nextValue);
        if (previous != null) {
            throw parser.syntax("Duplicate member of trait: '" + nextKey.getValue() + '\'');
        }
    }
}

