/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IdRefTrait
extends AbstractTrait
implements ToSmithyBuilder<IdRefTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#idRef");
    private final Selector selector;
    private final boolean failWhenMissing;
    private final String errorMessage;

    private IdRefTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.selector = builder.selector;
        this.failWhenMissing = builder.failWhenMissing;
        this.errorMessage = builder.errorMessage;
    }

    public Selector getSelector() {
        return this.selector == null ? Selector.IDENTITY : this.selector;
    }

    public boolean failWhenMissing() {
        return this.failWhenMissing;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Builder toBuilder() {
        return ((Builder)IdRefTrait.builder().sourceLocation(this.getSourceLocation())).failWhenMissing(this.failWhenMissing).selector(this.selector).errorMessage(this.errorMessage);
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withOptionalMember("selector", Optional.ofNullable(this.selector).map(Object::toString).map(Node::from)).withOptionalMember("errorMessage", this.getErrorMessage().map(Node::from));
        if (this.failWhenMissing) {
            builder = builder.withMember("failWhenMissing", Node.from(true));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<IdRefTrait, Builder> {
        private Selector selector;
        private boolean failWhenMissing;
        private String errorMessage;

        private Builder() {
        }

        public Builder failWhenMissing(boolean failWhenMissing) {
            this.failWhenMissing = failWhenMissing;
            return this;
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public IdRefTrait build() {
            return new IdRefTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public IdRefTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)IdRefTrait.builder().sourceLocation(value);
            value.expectObjectNode().getMember("selector", Selector::fromNode, builder::selector).getBooleanMember("failWhenMissing", builder::failWhenMissing).getStringMember("errorMessage", builder::errorMessage);
            IdRefTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

