/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node.internal;

import java.io.IOException;
import java.io.Writer;
import software.amazon.smithy.model.node.internal.JsonWriter;

final class PrettyPrintWriter
extends JsonWriter {
    private final String indentString;
    private int indent;

    PrettyPrintWriter(Writer writer, String indentString) {
        super(writer);
        this.indentString = indentString;
    }

    @Override
    void writeArrayOpen() throws IOException {
        ++this.indent;
        this.writer.write(91);
        this.writeNewLine();
    }

    @Override
    void writeArrayClose() throws IOException {
        --this.indent;
        this.writeNewLine();
        this.writer.write(93);
    }

    @Override
    void writeArraySeparator() throws IOException {
        this.writer.write(44);
        if (!this.writeNewLine()) {
            this.writer.write(32);
        }
    }

    @Override
    void writeObjectOpen() throws IOException {
        ++this.indent;
        this.writer.write(123);
        this.writeNewLine();
    }

    @Override
    void writeObjectClose() throws IOException {
        --this.indent;
        this.writeNewLine();
        this.writer.write(125);
    }

    @Override
    void writeMemberSeparator() throws IOException {
        this.writer.write(58);
        this.writer.write(32);
    }

    @Override
    void writeObjectSeparator() throws IOException {
        this.writer.write(44);
        if (!this.writeNewLine()) {
            this.writer.write(32);
        }
    }

    private boolean writeNewLine() throws IOException {
        if (this.indentString == null) {
            return false;
        }
        this.writer.write(System.lineSeparator());
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(this.indentString);
        }
        return true;
    }
}

