/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

final class TopDownSelector
implements InternalSelector {
    private final InternalSelector qualifier;
    private final InternalSelector disqualifier;

    TopDownSelector(List<InternalSelector> selectors) {
        this.qualifier = selectors.get(0);
        this.disqualifier = selectors.size() > 1 ? selectors.get(1) : null;
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        if (shape.isServiceShape() || shape.isResourceShape() || shape.isOperationShape()) {
            return this.pushMatch(false, context, shape, next, new HashSet<ShapeId>());
        }
        return InternalSelector.Response.CONTINUE;
    }

    private InternalSelector.Response pushMatch(boolean qualified, Context context, Shape shape, InternalSelector.Receiver next, Set<ShapeId> visited) {
        if (visited.contains(shape.getId())) {
            return InternalSelector.Response.CONTINUE;
        }
        visited.add(shape.getId());
        if (!qualified && context.receivedShapes(shape, this.qualifier)) {
            qualified = true;
        }
        if (qualified && this.disqualifier != null && context.receivedShapes(shape, this.disqualifier)) {
            qualified = false;
        }
        if (qualified && next.apply(context, shape) == InternalSelector.Response.STOP) {
            return InternalSelector.Response.STOP;
        }
        for (Relationship rel : context.neighborIndex.getProvider().getNeighbors(shape)) {
            if (!rel.getNeighborShape().isPresent() || rel.getNeighborShapeId().equals(shape.getId()) || rel.getRelationshipType() != RelationshipType.RESOURCE && rel.getRelationshipType() != RelationshipType.OPERATION || this.pushMatch(qualified, context, rel.getNeighborShape().get(), next, visited) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }
}

