/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.suppressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.SuppressTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventDecorator;
import software.amazon.smithy.model.validation.suppressions.SeverityOverride;
import software.amazon.smithy.model.validation.suppressions.Suppression;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ModelBasedEventDecorator {
    private static final String SUPPRESSIONS = "suppressions";
    private static final String SEVERITY_OVERRIDES = "severityOverrides";
    private final List<Suppression> suppressions = new ArrayList<Suppression>();
    private final List<SeverityOverride> severityOverrides = new ArrayList<SeverityOverride>();

    public ModelBasedEventDecorator suppressions(Collection<? extends Suppression> suppressions) {
        this.suppressions.clear();
        this.suppressions.addAll(suppressions);
        return this;
    }

    public ModelBasedEventDecorator severityOverrides(Collection<? extends SeverityOverride> severityOverrides) {
        this.severityOverrides.clear();
        this.severityOverrides.addAll(severityOverrides);
        return this;
    }

    public ValidatedResult<ValidationEventDecorator> createDecorator(final Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        final ArrayList<Suppression> loadedSuppressions = new ArrayList<Suppression>(this.suppressions);
        ModelBasedEventDecorator.loadMetadataSuppressions(model, loadedSuppressions, events);
        final ArrayList<SeverityOverride> loadedSeverityOverrides = new ArrayList<SeverityOverride>(this.severityOverrides);
        ModelBasedEventDecorator.loadMetadataSeverityOverrides(model, loadedSeverityOverrides, events);
        for (int i = 0; i < events.size(); ++i) {
            events.set(i, ModelBasedEventDecorator.modifyEventSeverity(model, (ValidationEvent)events.get(i), loadedSuppressions, loadedSeverityOverrides));
        }
        return new ValidatedResult<ValidationEventDecorator>(new ValidationEventDecorator(){

            @Override
            public boolean canDecorate(ValidationEvent ev) {
                return true;
            }

            @Override
            public ValidationEvent decorate(ValidationEvent ev) {
                return ModelBasedEventDecorator.modifyEventSeverity(model, ev, loadedSuppressions, loadedSeverityOverrides);
            }
        }, (List<ValidationEvent>)events);
    }

    private static void loadMetadataSeverityOverrides(Model model, List<SeverityOverride> severityOverrides, List<ValidationEvent> events) {
        model.getMetadataProperty(SEVERITY_OVERRIDES).ifPresent(value -> {
            try {
                List<ObjectNode> values = value.expectArrayNode().getElementsAs(ObjectNode.class);
                for (ObjectNode rule : values) {
                    try {
                        severityOverrides.add(SeverityOverride.fromMetadata(rule));
                    }
                    catch (SourceException e) {
                        events.add(ValidationEvent.fromSourceException(e));
                    }
                }
            }
            catch (SourceException e) {
                events.add(ValidationEvent.fromSourceException(e));
            }
        });
    }

    private static void loadMetadataSuppressions(Model model, List<Suppression> suppressions, List<ValidationEvent> events) {
        model.getMetadataProperty(SUPPRESSIONS).ifPresent(value -> {
            try {
                List<ObjectNode> values = value.expectArrayNode().getElementsAs(ObjectNode.class);
                for (ObjectNode rule : values) {
                    try {
                        suppressions.add(Suppression.fromMetadata(rule));
                    }
                    catch (SourceException e) {
                        events.add(ValidationEvent.fromSourceException(e));
                    }
                }
            }
            catch (SourceException e) {
                events.add(ValidationEvent.fromSourceException(e));
            }
        });
    }

    private static ValidationEvent modifyEventSeverity(Model model, ValidationEvent event, List<Suppression> suppressions, List<SeverityOverride> severityOverrides) {
        Suppression suppression;
        Object target;
        Shape shape;
        if (!event.getSeverity().canSuppress()) {
            return event;
        }
        if (event.getShapeId().isPresent() && (shape = (Shape)model.getShape((ShapeId)(target = event.getShapeId().get())).orElse(null)) != null && shape.hasTrait(SuppressTrait.class) && (suppression = Suppression.fromSuppressTrait(shape)).test(event)) {
            return ModelBasedEventDecorator.changeSeverity(event, Severity.SUPPRESSED, suppression.getReason().orElse(null));
        }
        for (Suppression suppression2 : suppressions) {
            if (!suppression2.test(event)) continue;
            return ModelBasedEventDecorator.changeSeverity(event, Severity.SUPPRESSED, suppression2.getReason().orElse(null));
        }
        Severity appliedSeverity = event.getSeverity();
        for (SeverityOverride override : severityOverrides) {
            Severity overrideResult = override.apply(event);
            if (overrideResult.ordinal() <= appliedSeverity.ordinal()) continue;
            appliedSeverity = overrideResult;
        }
        return ModelBasedEventDecorator.changeSeverity(event, appliedSeverity, null);
    }

    private static ValidationEvent changeSeverity(ValidationEvent event, Severity severity, String reason) {
        if (event.getSeverity() == severity) {
            return event;
        }
        ValidationEvent.Builder builder = event.toBuilder();
        builder.severity(severity);
        if (reason != null) {
            builder.suppressionReason(reason);
        }
        return builder.build();
    }
}

