/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.selector.IdentitySelector;
import software.amazon.smithy.model.selector.SelectorParser;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.Shape;

public interface Selector {
    public static final Selector IDENTITY = new IdentitySelector();

    public static Selector parse(String expression) {
        if (expression.equals("*")) {
            return IDENTITY;
        }
        return SelectorParser.parse(expression);
    }

    public static Selector fromNode(Node node) {
        try {
            return Selector.parse(node.expectStringNode().getValue());
        }
        catch (SelectorSyntaxException e) {
            throw new SourceException(e.getMessage(), node, e);
        }
    }

    default public Set<Shape> select(Model model) {
        return this.shapes(model).collect(Collectors.toSet());
    }

    default public Set<Shape> select(Model model, StartingContext context) {
        return this.shapes(model, context).collect(Collectors.toSet());
    }

    default public void consumeMatches(Model model, Consumer<ShapeMatch> shapeMatchConsumer) {
        this.matches(model).forEach(shapeMatchConsumer);
    }

    default public void consumeMatches(Model model, StartingContext context, Consumer<ShapeMatch> shapeMatchConsumer) {
        this.matches(model, context).forEach(shapeMatchConsumer);
    }

    default public Stream<Shape> shapes(Model model) {
        return this.shapes(model, StartingContext.DEFAULT);
    }

    default public Stream<Shape> shapes(Model model, StartingContext context) {
        return this.matches(model, context).map(ShapeMatch::getShape);
    }

    default public Stream<ShapeMatch> matches(Model model) {
        return this.matches(model, StartingContext.DEFAULT);
    }

    default public Stream<ShapeMatch> matches(Model model, StartingContext startingContext) {
        throw new UnsupportedOperationException("matches(model, context) is not implemented");
    }

    @Deprecated
    default public Runner runner() {
        return new Runner(this);
    }

    public static final class StartingContext {
        public static final StartingContext DEFAULT = new StartingContext();
        private final Collection<? extends Shape> startingShapes;

        public StartingContext() {
            this(null);
        }

        public StartingContext(Collection<? extends Shape> startingShapes) {
            this.startingShapes = startingShapes;
        }

        public Collection<? extends Shape> getStartingShapes() {
            return this.startingShapes;
        }
    }

    @Deprecated
    public static final class Runner {
        private final Selector selector;
        private Model model;

        Runner(Selector selector) {
            this.selector = selector;
        }

        @Deprecated
        public Runner model(Model model) {
            this.model = model;
            return this;
        }

        @Deprecated
        public Set<Shape> selectShapes() {
            return this.selector.select(Objects.requireNonNull(this.model, "model not set"));
        }

        @Deprecated
        public void selectMatches(BiConsumer<Shape, Map<String, Set<Shape>>> matchConsumer) {
            this.selector.consumeMatches(Objects.requireNonNull(this.model, "model not set"), m -> matchConsumer.accept(m.getShape(), (Map<String, Set<Shape>>)m));
        }
    }

    public static final class ShapeMatch
    extends HashMap<String, Set<Shape>> {
        private final Shape shape;

        public ShapeMatch(Shape shape, Map<String, Set<Shape>> variables) {
            super(variables);
            this.shape = shape;
        }

        public Shape getShape() {
            return this.shape;
        }
    }
}

