/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NamedMemberUtils;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.utils.BuilderRef;

public final class IntEnumShape
extends IntegerShape {
    private final Map<String, MemberShape> members;
    private volatile Map<String, Integer> enumValues;

    private IntEnumShape(Builder builder) {
        super(builder);
        this.members = NamedMemberUtils.computeMixinMembers(builder.getMixins(), (BuilderRef<Map<String, MemberShape>>)builder.members, this.getId(), this.getSourceLocation());
        this.validateMemberShapeIds();
        if (this.members.size() < 1) {
            throw new SourceException("intEnum shapes must have at least one member", this.getSourceLocation());
        }
    }

    public Map<String, Integer> getEnumValues() {
        if (this.enumValues == null) {
            LinkedHashMap<String, Integer> values = new LinkedHashMap<String, Integer>(this.members.size());
            for (MemberShape member : this.members()) {
                values.put(member.getMemberName(), member.expectTrait(EnumValueTrait.class).expectIntValue());
            }
            this.enumValues = Collections.unmodifiableMap(values);
        }
        return this.enumValues;
    }

    @Override
    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return this.updateBuilder(IntEnumShape.builder());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.intEnumShape(this);
    }

    @Override
    public Optional<IntEnumShape> asIntEnumShape() {
        return Optional.of(this);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.INT_ENUM;
    }

    public static class Builder
    extends IntegerShape.Builder {
        private final BuilderRef<Map<String, MemberShape>> members = BuilderRef.forOrderedMap();

        @Override
        public IntEnumShape build() {
            return new IntEnumShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.INT_ENUM;
        }

        @Override
        public Builder id(ShapeId shapeId) {
            super.id(shapeId);
            for (MemberShape member : ((Map)this.members.peek()).values()) {
                this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
            }
            return this;
        }

        @Override
        public Builder id(String shapeId) {
            return this.id(ShapeId.from(shapeId));
        }

        public Builder members(Collection<MemberShape> members) {
            this.clearMembers();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return this;
        }

        @Override
        public Builder clearMembers() {
            this.members.clear();
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            if (!member.getTarget().equals(UnitTypeTrait.UNIT)) {
                throw new SourceException(String.format("intEnum members may only target `smithy.api#Unit`, but found `%s`", member.getTarget()), this.getSourceLocation());
            }
            ((Map)this.members.get()).put(member.getMemberName(), member);
            return this;
        }

        public Builder addMember(String memberName, int enumValue) {
            return this.addMember(memberName, enumValue, null);
        }

        public Builder addMember(String memberName, int enumValue, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().target(UnitTypeTrait.UNIT).id(this.getId().withMember(memberName))).addTrait(EnumValueTrait.builder().intValue(enumValue).build());
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.addMember(builder.build());
        }

        public Builder removeMember(String member) {
            if (this.members.hasValue()) {
                ((Map)this.members.get()).remove(member);
            }
            return this;
        }

        @Override
        public Builder addMixin(Shape shape) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before adding a mixin");
            }
            super.addMixin(shape);
            NamedMemberUtils.cleanMixins(shape, (Map)this.members.get());
            return this;
        }

        @Override
        public Builder removeMixin(ToShapeId shape) {
            super.removeMixin(shape);
            NamedMemberUtils.removeMixin(shape, (Map)this.members.get());
            return this;
        }

        @Override
        public Builder flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return this;
            }
            this.members(NamedMemberUtils.flattenMixins((Map)this.members.get(), this.getMixins(), this.getId(), this.getSourceLocation()));
            return (Builder)super.flattenMixins();
        }
    }
}

