/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class ExclusiveStructureMemberTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        HashSet<ShapeId> exclusiveMemberTraits = new HashSet<ShapeId>();
        HashSet<ShapeId> exclusiveTargetTraits = new HashSet<ShapeId>();
        for (Shape shape : model.getShapesWithTrait(TraitDefinition.class)) {
            TraitDefinition traitDefinition = shape.expectTrait(TraitDefinition.class);
            if (traitDefinition.isStructurallyExclusiveByTarget()) {
                exclusiveTargetTraits.add(shape.getId());
                continue;
            }
            if (!traitDefinition.isStructurallyExclusiveByMember()) continue;
            exclusiveMemberTraits.add(shape.getId());
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getStructureShapes()) {
            this.validateExclusiveMembers(shape, exclusiveMemberTraits, events);
            this.validateExclusiveTargets(model, shape, exclusiveTargetTraits, events);
        }
        return events;
    }

    private void validateExclusiveMembers(Shape shape, Set<ShapeId> exclusiveMemberTraits, List<ValidationEvent> events) {
        for (ShapeId traitId : exclusiveMemberTraits) {
            ArrayList<String> matches = new ArrayList<String>();
            for (MemberShape member : shape.members()) {
                if (!member.findTrait(traitId).isPresent()) continue;
                matches.add(member.getMemberName());
            }
            if (matches.size() <= 1) continue;
            events.add(this.error(shape, String.format("The `%s` trait can be applied to only a single member of a shape, but it was found on the following members: %s", Trait.getIdiomaticTraitName(traitId), ValidationUtils.tickedList(matches))));
        }
    }

    private void validateExclusiveTargets(Model model, Shape shape, Set<ShapeId> exclusiveTargets, List<ValidationEvent> events) {
        for (ShapeId id : exclusiveTargets) {
            ArrayList<String> matches = new ArrayList<String>();
            for (MemberShape member : shape.members()) {
                if (!this.memberTargetHasTrait(model, member, id)) continue;
                matches.add(member.getMemberName());
            }
            if (matches.size() <= 1) continue;
            events.add(this.error(shape, String.format("Only a single member of a structure can target a shape marked with the `%s` trait, but it was found on the following members: %s", Trait.getIdiomaticTraitName(id), ValidationUtils.tickedList(matches))));
        }
    }

    private boolean memberTargetHasTrait(Model model, MemberShape member, ShapeId trait) {
        return model.getShape(member.getTarget()).flatMap(target -> target.findTrait(trait)).isPresent();
    }
}

