/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class IdempotencyTokenIgnoredValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.getAppliedTraits().contains(IdempotencyTokenTrait.ID)) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NeighborProvider reverse = NeighborProviderIndex.of(model).getReverseProvider();
        for (MemberShape memberShape : model.getMemberShapesWithTrait(IdempotencyTokenTrait.class)) {
            Shape container = model.expectShape(memberShape.getContainer());
            if (!container.isStructureShape() || container.hasTrait(MixinTrait.class)) continue;
            IdempotencyTokenTrait trait = memberShape.expectTrait(IdempotencyTokenTrait.class);
            this.checkRelationships(container.asStructureShape().get(), memberShape, trait, reverse, events);
        }
        return events;
    }

    private void checkRelationships(StructureShape containerShape, MemberShape memberShape, Trait trait, NeighborProvider reverse, List<ValidationEvent> events) {
        TreeMap<RelationshipType, List<ShapeId>> ignoredRelationships = new TreeMap<RelationshipType, List<ShapeId>>();
        List<Relationship> relationships = reverse.getNeighbors(containerShape);
        for (Relationship relationship : relationships) {
            if (relationship.getRelationshipType() == RelationshipType.MEMBER_CONTAINER || relationship.getRelationshipType() == RelationshipType.INPUT) continue;
            ignoredRelationships.computeIfAbsent(relationship.getRelationshipType(), x -> new ArrayList()).add(relationship.getShape().getId());
        }
        if (!ignoredRelationships.isEmpty()) {
            events.add(this.emit(memberShape, trait, ignoredRelationships));
        }
    }

    private ValidationEvent emit(MemberShape memberShape, Trait trait, Map<RelationshipType, List<ShapeId>> ignoredRelationships) {
        String message = "The `idempotencyToken` trait only has an effect when applied to a top-level operation input member, but it was applied and ignored in the following contexts: " + this.formatIgnoredRelationships(ignoredRelationships);
        return this.warning((Shape)memberShape, trait, message);
    }

    private String formatIgnoredRelationships(Map<RelationshipType, List<ShapeId>> ignoredRelationships) {
        ArrayList<String> relationshipTypeBindings = new ArrayList<String>();
        for (Map.Entry<RelationshipType, List<ShapeId>> ignoredRelationshipType : ignoredRelationships.entrySet()) {
            StringBuilder buf = new StringBuilder(ignoredRelationshipType.getKey().toString().toLowerCase(Locale.US).replace("_", " "));
            Set bindings = ignoredRelationshipType.getValue().stream().map(ShapeId::toString).collect(Collectors.toCollection(TreeSet::new));
            buf.append(": [").append(String.join((CharSequence)", ", bindings)).append("]");
            relationshipTypeBindings.add(buf.toString());
        }
        return "{" + String.join((CharSequence)", ", relationshipTypeBindings) + "}";
    }
}

