/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;

public final class MemberShouldReferenceResourceValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        Set<String> identifierNames = this.getAllIdentifierNames(model);
        if (identifierNames.isEmpty()) {
            return ListUtils.of();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapes()) {
            Set<ShapeId> potentialReferences;
            if (!identifierNames.contains(member.getMemberName()) || !model.expectShape(member.getTarget()).isStringShape() || (potentialReferences = this.computePotentialReferences(model, member)).isEmpty()) continue;
            events.add(this.warning(member, String.format("This member appears to reference the following resources without being included in a `@references` trait: [%s]", ValidationUtils.tickedList(potentialReferences))));
        }
        return events;
    }

    private Set<String> getAllIdentifierNames(Model model) {
        HashSet<String> identifierNames = new HashSet<String>();
        for (ResourceShape resource : model.getResourceShapes()) {
            identifierNames.addAll(resource.getIdentifiers().keySet());
        }
        return identifierNames;
    }

    private Set<ShapeId> computePotentialReferences(Model model, MemberShape member) {
        HashSet<ShapeId> resourcesToIgnore = new HashSet<ShapeId>();
        this.ignoreReferencedResources(member, resourcesToIgnore);
        this.ignoreReferencedResources(model.expectShape(member.getContainer()), resourcesToIgnore);
        HashSet<ShapeId> potentialResources = new HashSet<ShapeId>();
        for (ResourceShape resource : model.getResourceShapes()) {
            this.computeResourcesToIgnore(model, member, resource, resourcesToIgnore);
            if (resourcesToIgnore.contains(resource.getId()) || !this.isIdentifierMatch(resource, member)) continue;
            potentialResources.add(resource.getId());
        }
        potentialResources.removeAll(resourcesToIgnore);
        return potentialResources;
    }

    private void computeResourcesToIgnore(Model model, MemberShape member, ResourceShape resource, Set<ShapeId> resourcesToIgnore) {
        List<PathFinder.Path> resourceMemberPaths = PathFinder.create(model).search((ToShapeId)resource, ListUtils.of((Object)member));
        if (!resourceMemberPaths.isEmpty()) {
            for (PathFinder.Path path : resourceMemberPaths) {
                for (Shape pathShape : path.getShapes()) {
                    if (!pathShape.isResourceShape()) continue;
                    ResourceShape resourceShape = (ResourceShape)pathShape;
                    resourcesToIgnore.add(resourceShape.getId());
                    resourcesToIgnore.addAll(resourceShape.getResources());
                }
            }
        }
    }

    private void ignoreReferencedResources(Shape shape, Set<ShapeId> resourcesToIgnore) {
        if (shape.hasTrait(ReferencesTrait.class)) {
            for (ReferencesTrait.Reference reference : shape.expectTrait(ReferencesTrait.class).getReferences()) {
                resourcesToIgnore.add(reference.getResource());
            }
        }
    }

    private boolean isIdentifierMatch(ResourceShape resource, MemberShape member) {
        Map<String, ShapeId> identifiers = resource.getIdentifiers();
        return identifiers.containsKey(member.getMemberName()) && identifiers.get(member.getMemberName()).equals(member.getTarget());
    }
}

