/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.ValidationLoader;
import software.amazon.smithy.model.loader.ValidatorDefinition;
import software.amazon.smithy.model.loader.ValidatorFromDefinitionFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventDecorator;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.model.validation.suppressions.ModelBasedEventDecorator;
import software.amazon.smithy.model.validation.validators.ResourceCycleValidator;
import software.amazon.smithy.model.validation.validators.TargetValidator;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;

final class ModelValidator
implements Validator {
    private static final Map<Class<?>, Validator> CORRECTNESS_VALIDATORS = MapUtils.of(TargetValidator.class, (Object)new TargetValidator(), ResourceCycleValidator.class, (Object)new ResourceCycleValidator());
    private final ValidatorFactory validatorFactory;
    private final List<ValidationEvent> events;
    private final List<Validator> validators;
    private final List<Validator> criticalValidators;
    private final ValidationEventDecorator validationEventDecorator;
    private final Consumer<ValidationEvent> eventListener;
    private final boolean legacyValidationMode;

    ModelValidator(Builder builder) {
        this.validatorFactory = builder.validatorFactory;
        this.eventListener = builder.eventListener;
        this.validationEventDecorator = builder.validationEventDecorator;
        this.events = (List)builder.includeEvents.copy();
        this.validators = (List)builder.validators.copy();
        this.criticalValidators = (List)builder.criticalValidators.copy();
        this.legacyValidationMode = builder.legacyValidationMode;
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        return new LoadedModelValidator(model, this).validate();
    }

    static Builder builder() {
        return new Builder();
    }

    static ValidatorFactory defaultValidationFactory() {
        return LazyValidatorFactoryHolder.INSTANCE;
    }

    static final class Builder
    implements SmithyBuilder<ModelValidator> {
        private final BuilderRef<List<Validator>> validators = BuilderRef.forList();
        private final BuilderRef<List<Validator>> criticalValidators = BuilderRef.forList();
        private final BuilderRef<List<ValidationEvent>> includeEvents = BuilderRef.forList();
        private ValidatorFactory validatorFactory = LazyValidatorFactoryHolder.INSTANCE;
        private Consumer<ValidationEvent> eventListener = event -> {};
        private ValidationEventDecorator validationEventDecorator;
        private boolean legacyValidationMode = false;

        private Builder() {
        }

        public Builder addValidators(Collection<? extends Validator> validators) {
            for (Validator validator : validators) {
                this.addValidator(validator);
            }
            return this;
        }

        public Builder addValidator(Validator validator) {
            if (!CORRECTNESS_VALIDATORS.containsKey(validator.getClass())) {
                if (ValidationUtils.isCriticalValidator(validator.getClass())) {
                    ((List)this.criticalValidators.get()).add(validator);
                } else {
                    ((List)this.validators.get()).add(validator);
                }
            }
            return this;
        }

        public Builder validatorFactory(ValidatorFactory validatorFactory, ValidationEventDecorator validationEventDecorator) {
            this.validatorFactory = Objects.requireNonNull(validatorFactory);
            this.validationEventDecorator = validationEventDecorator;
            return this;
        }

        public Builder eventListener(Consumer<ValidationEvent> eventListener) {
            this.eventListener = Objects.requireNonNull(eventListener);
            return this;
        }

        public Builder includeEvents(List<ValidationEvent> events) {
            ((List)this.includeEvents.get()).addAll(events);
            return this;
        }

        public Builder legacyValidationMode(boolean legacyValidationMode) {
            this.legacyValidationMode = legacyValidationMode;
            return this;
        }

        public ModelValidator build() {
            this.addValidators(this.validatorFactory.loadBuiltinValidators());
            return new ModelValidator(this);
        }
    }

    private static final class LoadedModelValidator {
        private final Model model;
        private final List<Validator> validators;
        private final List<Validator> criticalValidators;
        private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
        private final ValidationEventDecorator validationEventDecorator;
        private final Consumer<ValidationEvent> eventListener;
        private final boolean legacyValidationMode;

        private LoadedModelValidator(Model model, ModelValidator validator) {
            this.model = model;
            this.eventListener = validator.eventListener;
            this.validators = new ArrayList<Validator>(validator.validators);
            this.criticalValidators = Collections.unmodifiableList(validator.criticalValidators);
            this.legacyValidationMode = validator.legacyValidationMode;
            ModelBasedEventDecorator modelBasedEventDecorator = new ModelBasedEventDecorator();
            ValidatedResult<ValidationEventDecorator> result = modelBasedEventDecorator.createDecorator(model);
            this.validationEventDecorator = result.getResult().map(decorator -> ValidationEventDecorator.compose(ListUtils.of((Object)decorator, (Object)validator.validationEventDecorator))).orElse(validator.validationEventDecorator);
            for (ValidationEvent event : result.getValidationEvents()) {
                if (this.validationEventDecorator.canDecorate(event)) {
                    event = this.validationEventDecorator.decorate(event);
                }
                this.events.add(event);
            }
            for (ValidationEvent event : validator.events) {
                this.pushEvent(event);
            }
            this.loadModelValidators(validator.validatorFactory);
        }

        private void loadModelValidators(ValidatorFactory validatorFactory) {
            ValidatedResult<List<ValidatorDefinition>> loaded = ValidationLoader.loadValidators(this.model.getMetadata());
            this.pushEvents(loaded.getValidationEvents());
            List definitions = loaded.getResult().orElseGet(Collections::emptyList);
            ValidatorFromDefinitionFactory factory = new ValidatorFromDefinitionFactory(validatorFactory);
            for (ValidatorDefinition val : definitions) {
                ValidatedResult<Validator> result = factory.loadValidator(val);
                result.getResult().ifPresent(this.validators::add);
                this.pushEvents(result.getValidationEvents());
                if (!result.getValidationEvents().isEmpty() || result.getResult().isPresent()) continue;
                ValidationEvent event = LoadedModelValidator.unknownValidatorError(val.name, val.sourceLocation);
                this.pushEvent(event);
            }
        }

        private static ValidationEvent unknownValidatorError(String name, SourceLocation location) {
            return ValidationEvent.builder().id("UnknownValidator_" + name).severity(Severity.WARNING).sourceLocation(location).message("Unable to locate a validator named `" + name + "`").build();
        }

        private void pushEvents(List<ValidationEvent> source) {
            for (ValidationEvent event : source) {
                this.pushEvent(event);
            }
        }

        private void pushEvent(ValidationEvent event) {
            this.events.add(this.updateAndEmitEvent(event));
        }

        private ValidationEvent updateAndEmitEvent(ValidationEvent event) {
            if (this.validationEventDecorator.canDecorate(event)) {
                event = this.validationEventDecorator.decorate(event);
            }
            this.eventListener.accept(event);
            return event;
        }

        private List<ValidationEvent> validate() {
            this.events.addAll(this.streamEvents(CORRECTNESS_VALIDATORS.values().stream()));
            if (LoaderUtils.containsErrorEvents(this.events)) {
                return this.events;
            }
            this.events.addAll(this.streamEvents(this.criticalValidators.parallelStream()));
            if (!this.legacyValidationMode && LoaderUtils.containsErrorEvents(this.events)) {
                return this.events;
            }
            this.events.addAll(this.streamEvents(this.validators.parallelStream()));
            return this.events;
        }

        private List<ValidationEvent> streamEvents(Stream<Validator> validators) {
            return validators.flatMap(validator -> validator.validate(this.model).stream()).filter(this::filterPrelude).map(this::updateAndEmitEvent).collect(Collectors.toList());
        }

        private boolean filterPrelude(ValidationEvent event) {
            return event.getSeverity() == Severity.ERROR || !event.getShapeId().filter(Prelude::isPreludeShape).isPresent();
        }
    }

    private static final class LazyValidatorFactoryHolder {
        static final ValidatorFactory INSTANCE = ValidatorFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        private LazyValidatorFactoryHolder() {
        }
    }
}

