/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class LoaderUtils {
    private LoaderUtils() {
    }

    static void checkForAdditionalProperties(ObjectNode node, ShapeId shape, Collection<String> properties, List<ValidationEvent> events) {
        try {
            node.expectNoAdditionalProperties(properties);
        }
        catch (ExpectationNotMetException e) {
            ValidationEvent event = ValidationEvent.fromSourceException(e).toBuilder().shapeId(shape).severity(Severity.WARNING).build();
            events.add(event);
        }
    }

    static boolean isVersionSupported(String versionString) {
        return versionString.equals("1") || versionString.equals("1.0");
    }

    static ValidationEvent onShapeConflict(ShapeId id, SourceLocation a, SourceLocation b) {
        return ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(b).shapeId(id).message(String.format("Conflicting shape definition for `%s` found at `%s` and `%s`", id, a, b)).build();
    }

    static boolean isSameLocation(FromSourceLocation a, FromSourceLocation b) {
        SourceLocation sa = a.getSourceLocation();
        SourceLocation sb = b.getSourceLocation();
        return sa != SourceLocation.NONE && sa.equals(sb);
    }
}

