/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

final class RemoveShapes {
    private final Collection<Shape> toRemove;
    private final List<ModelTransformerPlugin> plugins;

    RemoveShapes(Collection<Shape> toRemove, List<ModelTransformerPlugin> plugins) {
        this.toRemove = toRemove;
        this.plugins = plugins;
    }

    Model transform(ModelTransformer transformer, Model model) {
        Model.Builder builder = model.toBuilder();
        HashSet<Shape> removed = new HashSet<Shape>(this.toRemove);
        for (Shape removedShape : this.toRemove) {
            builder.removeShape(removedShape.getId());
            removed.addAll(removedShape.members());
        }
        Model result = builder.build();
        for (ModelTransformerPlugin plugin : this.plugins) {
            result = plugin.onRemove(transformer, removed, result);
        }
        return result;
    }
}

