/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.ResourceIdentifierTrait;

public final class IdentifierBindingIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, Map<String, String>>> inputBindings = new HashMap<ShapeId, Map<ShapeId, Map<String, String>>>();
    private final Map<ShapeId, Map<ShapeId, Map<String, String>>> outputBindings = new HashMap<ShapeId, Map<ShapeId, Map<String, String>>>();
    private final SortedSet<String> allIdentifiers = new TreeSet<String>();
    private final Map<ShapeId, Map<ShapeId, BindingType>> bindingTypes = new HashMap<ShapeId, Map<ShapeId, BindingType>>();

    public IdentifierBindingIndex(Model model) {
        OperationIndex operationIndex = OperationIndex.of(model);
        for (ResourceShape resource : model.getResourceShapes()) {
            this.processResource(resource, operationIndex, model);
        }
    }

    public static IdentifierBindingIndex of(Model model) {
        return model.getKnowledge(IdentifierBindingIndex.class, IdentifierBindingIndex::new);
    }

    public BindingType getOperationBindingType(ToShapeId resource, ToShapeId operation) {
        return Optional.ofNullable(this.bindingTypes.get(resource.toShapeId())).flatMap(resourceMap -> Optional.ofNullable((BindingType)((Object)((Object)resourceMap.get(operation.toShapeId()))))).orElse(BindingType.NONE);
    }

    public Map<String, String> getOperationInputBindings(ToShapeId resource, ToShapeId operation) {
        return Optional.ofNullable(this.inputBindings.get(resource.toShapeId())).flatMap(resourceMap -> Optional.ofNullable((Map)resourceMap.get(operation.toShapeId()))).map(Collections::unmodifiableMap).orElseGet(Collections::emptyMap);
    }

    public Map<String, String> getOperationOutputBindings(ToShapeId resource, ToShapeId operation) {
        return Optional.ofNullable(this.outputBindings.get(resource.toShapeId())).flatMap(resourceMap -> Optional.ofNullable((Map)resourceMap.get(operation.toShapeId()))).map(Collections::unmodifiableMap).orElseGet(Collections::emptyMap);
    }

    @Deprecated
    public Map<String, String> getOperationBindings(ToShapeId resource, ToShapeId operation) {
        return this.getOperationInputBindings(resource, operation);
    }

    private void processResource(ResourceShape resource, OperationIndex operationIndex, Model model) {
        this.inputBindings.put(resource.getId(), new HashMap());
        this.outputBindings.put(resource.getId(), new HashMap());
        this.bindingTypes.put(resource.getId(), new HashMap());
        resource.getAllOperations().forEach(operationId -> {
            Map computedInputBindings = operationIndex.getInputShape((ToShapeId)operationId).map(inputShape -> this.computeBindings(resource, (StructureShape)inputShape)).orElse(Collections.emptyMap());
            this.inputBindings.get(resource.getId()).put((ShapeId)operationId, computedInputBindings);
            this.allIdentifiers.addAll(computedInputBindings.keySet());
            Map computedOutputBindings = operationIndex.getOutputShape((ToShapeId)operationId).map(outputShape -> this.computeBindings(resource, (StructureShape)outputShape)).orElse(Collections.emptyMap());
            this.outputBindings.get(resource.getId()).put((ShapeId)operationId, computedOutputBindings);
            this.allIdentifiers.addAll(computedOutputBindings.keySet());
            this.bindingTypes.get(resource.getId()).put((ShapeId)operationId, this.isCollection(resource, (ToShapeId)operationId) ? BindingType.COLLECTION : BindingType.INSTANCE);
        });
    }

    private boolean isCollection(ResourceShape resource, ToShapeId operationId) {
        return resource.getCollectionOperations().contains(operationId.toShapeId()) || resource.getCreate().isPresent() && resource.getCreate().get().toShapeId().equals(operationId) || resource.getList().isPresent() && resource.getList().get().toShapeId().equals(operationId);
    }

    private boolean isImplicitIdentifierBinding(MemberShape member, ResourceShape resource) {
        return resource.getIdentifiers().containsKey(member.getMemberName()) && member.hasTrait(RequiredTrait.ID) && member.getTarget().equals(resource.getIdentifiers().get(member.getMemberName()));
    }

    private Map<String, String> computeBindings(ResourceShape resource, StructureShape shape) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        for (MemberShape member : shape.getAllMembers().values()) {
            if (member.hasTrait(ResourceIdentifierTrait.ID)) {
                String bindingName = member.expectTrait(ResourceIdentifierTrait.class).getValue();
                bindings.put(bindingName, member.getMemberName());
                continue;
            }
            if (!this.isImplicitIdentifierBinding(member, resource)) continue;
            bindings.putIfAbsent(member.getMemberName(), member.getMemberName());
        }
        return bindings;
    }

    public static enum BindingType {
        INSTANCE,
        COLLECTION,
        NONE;

    }
}

