/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeToBuilder;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;

public abstract class Shape
implements FromSourceLocation,
Tagged,
ToShapeId,
Comparable<Shape> {
    private final ShapeId id;
    private final Map<ShapeId, Trait> traits;
    private final Map<ShapeId, Trait> introducedTraits;
    private final Map<ShapeId, Shape> mixins;
    private final transient SourceLocation source;
    private transient List<String> memberNames;
    private int hash;

    Shape(AbstractShapeBuilder<?, ?> builder, boolean expectMemberSegments) {
        this.source = builder.getSourceLocation();
        this.id = (ShapeId)SmithyBuilder.requiredState((String)"id", (Object)builder.getId());
        this.validateShapeId(expectMemberSegments);
        this.introducedTraits = MapUtils.copyOf(builder.getTraits());
        this.mixins = MapUtils.orderedCopyOf(builder.getMixins());
        if (this.mixins.isEmpty()) {
            this.traits = this.introducedTraits;
        } else {
            this.validateMixins(this.mixins, this.introducedTraits);
            HashMap<ShapeId, Trait> computedTraits = new HashMap<ShapeId, Trait>();
            for (Shape shape : this.mixins.values()) {
                computedTraits.putAll(MixinTrait.getNonLocalTraitsFromMap(shape.getAllTraits()));
            }
            computedTraits.putAll(this.introducedTraits);
            this.traits = Collections.unmodifiableMap(computedTraits);
        }
    }

    protected void validateMixins(Map<ShapeId, Shape> mixins, Map<ShapeId, Trait> introducedTraits) {
        TreeSet<String> invalid = new TreeSet<String>();
        for (Shape mixin : mixins.values()) {
            if (mixin.getType() == this.getType()) continue;
            invalid.add(mixin.getId().toString());
        }
        if (!invalid.isEmpty()) {
            String invalidList = String.join((CharSequence)"`, `", invalid);
            throw new SourceException(String.format("Mixins may only be mixed into shapes of the same type. The following mixins were applied to the %s shape `%s` which are not %1$s shapes: [`%s`]", new Object[]{this.getType(), this.getId(), invalidList}), this.source);
        }
    }

    protected MemberShape[] getRequiredMembers(AbstractShapeBuilder<?, ?> builder, String ... requiredMembersNames) {
        MemberShape[] members = new MemberShape[requiredMembersNames.length];
        int missingMemberCount = 0;
        for (int memberNameIndex = 0; memberNameIndex < requiredMembersNames.length; ++memberNameIndex) {
            String requiredMemberName = requiredMembersNames[memberNameIndex];
            MemberShape member = this.getRequiredMixinMember(builder, requiredMemberName);
            if (member != null) {
                members[memberNameIndex] = member;
                continue;
            }
            ++missingMemberCount;
        }
        if (missingMemberCount > 0) {
            ArrayList<String> missingMembers = new ArrayList<String>();
            for (int memberIndex = 0; memberIndex < members.length; ++memberIndex) {
                if (members[memberIndex] != null) continue;
                missingMembers.add(requiredMembersNames[memberIndex]);
            }
            throw this.missingRequiredMembersException(missingMembers);
        }
        return members;
    }

    private MemberShape getRequiredMixinMember(AbstractShapeBuilder<?, ?> builder, String requiredMemberName) {
        Optional<MemberShape> memberOnBuilder = builder.getMember(requiredMemberName);
        if (memberOnBuilder.isPresent()) {
            return memberOnBuilder.get();
        }
        MemberShape mostRecentMember = null;
        block0: for (Shape shape : builder.getMixins().values()) {
            for (MemberShape member : shape.members()) {
                if (!member.getMemberName().equals(requiredMemberName)) continue;
                mostRecentMember = member;
                continue block0;
            }
        }
        if (mostRecentMember == null) {
            return null;
        }
        return ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(this.getId().withMember(requiredMemberName))).target(mostRecentMember.getTarget()).source(this.getSourceLocation())).addMixin(mostRecentMember)).build();
    }

    private SourceException missingRequiredMembersException(List<String> missingMembersNames) {
        String missingRequired = missingMembersNames.size() > 1 ? "members" : "member";
        String missingMembers = String.join((CharSequence)", ", missingMembersNames);
        String message = String.format("Missing required %s of shape `%s`: %s", missingRequired, this.getId(), missingMembers);
        return new SourceException(message, this.getSourceLocation());
    }

    private void validateShapeId(boolean expectMember) {
        if (expectMember) {
            if (!this.getId().hasMember()) {
                throw new SourceException(String.format("Shapes of type `%s` must contain a member in their shape ID. Found `%s`", new Object[]{this.getType(), this.getId()}), this.getSourceLocation());
            }
        } else if (this.getId().hasMember()) {
            throw new SourceException(String.format("Shapes of type `%s` cannot contain a member in their shape ID. Found `%s`", new Object[]{this.getType(), this.getId()}), this.getSourceLocation());
        }
    }

    protected final void validateMemberShapeIds() {
        for (MemberShape member : this.members()) {
            if (member.getId().toString().startsWith(this.getId().toString())) continue;
            ShapeId expected = this.getId().withMember(member.getMemberName());
            throw new SourceException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", member.getMemberName(), this.getId(), expected, member.getId()), this.getSourceLocation());
        }
    }

    public static <B extends AbstractShapeBuilder<B, S>, S extends Shape> B shapeToBuilder(S shape) {
        return (B)shape.accept(new ShapeToBuilder());
    }

    public abstract ShapeType getType();

    public abstract <R> R accept(ShapeVisitor<R> var1);

    public final ShapeId getId() {
        return this.id;
    }

    public boolean hasTrait(String id) {
        return this.findTrait(id).isPresent();
    }

    public boolean hasTrait(ShapeId id) {
        return this.traits.containsKey(id);
    }

    public boolean hasTrait(Class<? extends Trait> traitClass) {
        return this.getTrait(traitClass).isPresent();
    }

    public Optional<Trait> findTrait(ShapeId id) {
        return Optional.ofNullable(this.traits.get(id));
    }

    public Optional<Trait> findTrait(String id) {
        return this.findTrait(ShapeId.from(Trait.makeAbsoluteName(id)));
    }

    public final <T extends Trait> Optional<T> getTrait(Class<T> traitClass) {
        for (Trait trait : this.traits.values()) {
            if (!traitClass.isInstance(trait)) continue;
            return Optional.of(trait);
        }
        return Optional.empty();
    }

    public final <T extends Trait> T expectTrait(Class<T> traitClass) {
        return (T)((Trait)this.getTrait(traitClass).orElseThrow(() -> new ExpectationNotMetException(String.format("Expected shape `%s` to have a trait `%s`", this.getId(), traitClass.getCanonicalName()), this)));
    }

    public final Map<ShapeId, Trait> getAllTraits() {
        return this.traits;
    }

    public <T extends Trait> Optional<T> getMemberTrait(Model model, Class<T> trait) {
        return this.getTrait(trait);
    }

    public Optional<Trait> findMemberTrait(Model model, String traitName) {
        return this.findTrait(traitName);
    }

    public Optional<BigDecimalShape> asBigDecimalShape() {
        return Optional.empty();
    }

    public Optional<BigIntegerShape> asBigIntegerShape() {
        return Optional.empty();
    }

    public Optional<BlobShape> asBlobShape() {
        return Optional.empty();
    }

    public Optional<BooleanShape> asBooleanShape() {
        return Optional.empty();
    }

    public Optional<ByteShape> asByteShape() {
        return Optional.empty();
    }

    public Optional<ShortShape> asShortShape() {
        return Optional.empty();
    }

    public Optional<FloatShape> asFloatShape() {
        return Optional.empty();
    }

    public Optional<DocumentShape> asDocumentShape() {
        return Optional.empty();
    }

    public Optional<DoubleShape> asDoubleShape() {
        return Optional.empty();
    }

    public Optional<IntegerShape> asIntegerShape() {
        return Optional.empty();
    }

    public Optional<IntEnumShape> asIntEnumShape() {
        return Optional.empty();
    }

    public Optional<ListShape> asListShape() {
        return Optional.empty();
    }

    @Deprecated
    public Optional<SetShape> asSetShape() {
        return Optional.empty();
    }

    public Optional<LongShape> asLongShape() {
        return Optional.empty();
    }

    public Optional<MapShape> asMapShape() {
        return Optional.empty();
    }

    public Optional<MemberShape> asMemberShape() {
        return Optional.empty();
    }

    public Optional<OperationShape> asOperationShape() {
        return Optional.empty();
    }

    public Optional<ResourceShape> asResourceShape() {
        return Optional.empty();
    }

    public Optional<ServiceShape> asServiceShape() {
        return Optional.empty();
    }

    public Optional<StringShape> asStringShape() {
        return Optional.empty();
    }

    public Optional<EnumShape> asEnumShape() {
        return Optional.empty();
    }

    public Optional<StructureShape> asStructureShape() {
        return Optional.empty();
    }

    public Optional<UnionShape> asUnionShape() {
        return Optional.empty();
    }

    public Optional<TimestampShape> asTimestampShape() {
        return Optional.empty();
    }

    public final boolean isBigDecimalShape() {
        return this.getType() == ShapeType.BIG_DECIMAL;
    }

    public final boolean isBigIntegerShape() {
        return this.getType() == ShapeType.BIG_INTEGER;
    }

    public final boolean isBlobShape() {
        return this.getType() == ShapeType.BLOB;
    }

    public final boolean isBooleanShape() {
        return this.getType() == ShapeType.BOOLEAN;
    }

    public final boolean isByteShape() {
        return this.getType() == ShapeType.BYTE;
    }

    public final boolean isShortShape() {
        return this.getType() == ShapeType.SHORT;
    }

    public final boolean isFloatShape() {
        return this.getType() == ShapeType.FLOAT;
    }

    public final boolean isDocumentShape() {
        return this.getType() == ShapeType.DOCUMENT;
    }

    public final boolean isDoubleShape() {
        return this.getType() == ShapeType.DOUBLE;
    }

    public final boolean isListShape() {
        return this.getType() == ShapeType.LIST;
    }

    @Deprecated
    public final boolean isSetShape() {
        return this.getType() == ShapeType.SET;
    }

    public final boolean isIntegerShape() {
        return this.getType() == ShapeType.INTEGER || this.getType() == ShapeType.INT_ENUM;
    }

    public final boolean isIntEnumShape() {
        return this.getType() == ShapeType.INT_ENUM;
    }

    public final boolean isLongShape() {
        return this.getType() == ShapeType.LONG;
    }

    public final boolean isMapShape() {
        return this.getType() == ShapeType.MAP;
    }

    public final boolean isMemberShape() {
        return this.getType() == ShapeType.MEMBER;
    }

    public final boolean isOperationShape() {
        return this.getType() == ShapeType.OPERATION;
    }

    public final boolean isResourceShape() {
        return this.getType() == ShapeType.RESOURCE;
    }

    public final boolean isServiceShape() {
        return this.getType() == ShapeType.SERVICE;
    }

    public final boolean isStringShape() {
        return this.getType() == ShapeType.STRING || this.getType() == ShapeType.ENUM;
    }

    public final boolean isEnumShape() {
        return this.getType() == ShapeType.ENUM;
    }

    public final boolean isStructureShape() {
        return this.getType() == ShapeType.STRUCTURE;
    }

    public final boolean isUnionShape() {
        return this.getType() == ShapeType.UNION;
    }

    public final boolean isTimestampShape() {
        return this.getType() == ShapeType.TIMESTAMP;
    }

    public Collection<MemberShape> members() {
        return this.getAllMembers().values();
    }

    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.getAllMembers().get(name));
    }

    public Map<String, MemberShape> getAllMembers() {
        return Collections.emptyMap();
    }

    public List<String> getMemberNames() {
        List result = this.memberNames;
        if (result == null) {
            this.memberNames = result = ListUtils.copyOf(this.getAllMembers().keySet());
        }
        return result;
    }

    public Set<ShapeId> getMixins() {
        return this.mixins.keySet();
    }

    public Map<ShapeId, Trait> getIntroducedTraits() {
        return this.introducedTraits;
    }

    @Override
    public ShapeId toShapeId() {
        return this.id;
    }

    public final List<String> getTags() {
        return this.getTrait(TagsTrait.class).map(StringListTrait::getValues).orElseGet(Collections::emptyList);
    }

    @Override
    public final SourceLocation getSourceLocation() {
        return this.source;
    }

    @Override
    public int compareTo(Shape other) {
        return this.getId().compareTo(other.getId());
    }

    public final String toString() {
        return "(" + (Object)((Object)this.getType()) + ": `" + this.getId() + "`)";
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Objects.hash(new Object[]{this.getType(), this.getId()});
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shape)) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        Shape other = (Shape)o;
        return this.getType() == other.getType() && this.getId().equals(other.getId()) && this.getMemberNames().equals(other.getMemberNames()) && this.getAllMembers().equals(other.getAllMembers()) && this.getAllTraits().equals(other.getAllTraits()) && this.mixins.equals(other.mixins);
    }

    <S extends Shape, B extends AbstractShapeBuilder<B, S>> B updateBuilder(B builder) {
        builder.id(this.getId());
        builder.source(this.getSourceLocation());
        builder.addTraits(this.getIntroducedTraits().values());
        builder.mixins(this.mixins.values());
        for (MemberShape member : this.members()) {
            if (!member.getMixins().isEmpty() && member.getIntroducedTraits().isEmpty()) continue;
            builder.addMember(member);
        }
        return builder;
    }
}

