/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RequestCompressionTrait
extends AbstractTrait
implements ToSmithyBuilder<RequestCompressionTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#requestCompression");
    public static final Set<String> SUPPORTED_COMPRESSION_ALGORITHMS = SetUtils.of((Object)"gzip");
    public static final String ENCODINGS = "encodings";
    private final List<String> encodings;

    private RequestCompressionTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.encodings = (List)builder.encodings.copy();
    }

    public List<String> getEncodings() {
        return this.encodings;
    }

    @Override
    protected Node createNode() {
        return ObjectNode.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember(ENCODINGS, Node.fromStrings(this.getEncodings())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation(this.getSourceLocation())).encodings(this.encodings);
    }

    public static final class Builder
    extends AbstractTraitBuilder<RequestCompressionTrait, Builder> {
        private final BuilderRef<List<String>> encodings = BuilderRef.forList();

        private Builder() {
        }

        public RequestCompressionTrait build() {
            return new RequestCompressionTrait(this);
        }

        public Builder encodings(List<String> encodings) {
            this.encodings.clear();
            ((List)this.encodings.get()).addAll(encodings);
            return this;
        }

        public Builder addEncoding(String encoding) {
            ((List)this.encodings.get()).add(encoding);
            return this;
        }

        public Builder clearEncodings() {
            this.encodings.clear();
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)RequestCompressionTrait.builder().sourceLocation(value);
            objectNode.expectArrayMember(RequestCompressionTrait.ENCODINGS, StringNode::getValue, builder::encodings);
            RequestCompressionTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

