/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.HashSet;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class FlattenPaginationInfo {
    private final ServiceShape service;

    FlattenPaginationInfo(ServiceShape service) {
        this.service = service;
    }

    public Model transform(ModelTransformer transformer, Model model) {
        Optional<PaginatedTrait> serviceLevelPagination = this.service.getTrait(PaginatedTrait.class);
        if (!serviceLevelPagination.isPresent()) {
            return model;
        }
        PaginatedIndex paginatedIndex = PaginatedIndex.of(model);
        HashSet<Shape> updatedShapes = new HashSet<Shape>();
        for (OperationShape operationShape : model.getOperationShapesWithTrait(PaginatedTrait.class)) {
            PaginationInfo paginationInfo = paginatedIndex.getPaginationInfo(this.service, operationShape).get();
            OperationShape updatedShape = ((OperationShape.Builder)operationShape.toBuilder().addTrait(paginationInfo.getPaginatedTrait())).build();
            updatedShapes.add(updatedShape);
        }
        updatedShapes.add(((ServiceShape.Builder)this.service.toBuilder().removeTrait(PaginatedTrait.ID)).build());
        return transformer.replaceShapes(model, updatedShapes);
    }
}

