/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanServiceRenames
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> shapes, Model model) {
        HashMap updatedServices = new HashMap();
        model.shapes(ServiceShape.class).forEach(service -> {
            for (Shape shape : shapes) {
                if (!service.getRename().containsKey(shape.getId())) continue;
                updatedServices.computeIfAbsent(service.getId(), id -> service.toBuilder()).removeRename(shape);
            }
        });
        if (updatedServices.isEmpty()) {
            return model;
        }
        Set shapesToReplace = updatedServices.values().stream().map(ServiceShape.Builder::build).collect(Collectors.toSet());
        return transformer.replaceShapes(model, shapesToReplace);
    }
}

