/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class HttpMessageTestCase
implements ToNode {
    private static final String ID = "id";
    private static final String PROTOCOL = "protocol";
    private static final String DOCUMENTATION = "documentation";
    private static final String AUTH_SCHEME = "authScheme";
    private static final String BODY = "body";
    private static final String BODY_MEDIA_TYPE = "bodyMediaType";
    private static final String PARAMS = "params";
    private static final String VENDOR_PARAMS = "vendorParams";
    private static final String HEADERS = "headers";
    private static final String FORBID_HEADERS = "forbidHeaders";
    private static final String REQUIRE_HEADERS = "requireHeaders";
    private final String id;
    private final String documentation;
    private final ShapeId protocol;
    private final ShapeId authScheme;
    private final String body;
    private final String bodyMediaType;
    private final ObjectNode params;
    private final ObjectNode vendorParams;
    private final Map<String, String> headers;
    private final List<String> forbidHeaders;
    private final List<String> requireHeaders;

    HttpMessageTestCase(Builder<?, ?> builder) {
        this.id = (String)SmithyBuilder.requiredState((String)ID, (Object)((Builder)builder).id);
        this.protocol = (ShapeId)SmithyBuilder.requiredState((String)PROTOCOL, (Object)((Builder)builder).protocol);
        this.documentation = ((Builder)builder).documentation;
        this.authScheme = ((Builder)builder).authScheme;
        this.body = ((Builder)builder).body;
        this.bodyMediaType = ((Builder)builder).bodyMediaType;
        this.params = ((Builder)builder).params;
        this.vendorParams = ((Builder)builder).vendorParams;
        this.headers = Collections.unmodifiableMap(new TreeMap(((Builder)builder).headers));
        this.forbidHeaders = ListUtils.copyOf((Collection)((Builder)builder).forbidHeaders);
        this.requireHeaders = ListUtils.copyOf((Collection)((Builder)builder).requireHeaders);
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public ShapeId getProtocol() {
        return this.protocol;
    }

    public Optional<ShapeId> getAuthScheme() {
        return Optional.ofNullable(this.authScheme);
    }

    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> getBodyMediaType() {
        return Optional.ofNullable(this.bodyMediaType);
    }

    public ObjectNode getParams() {
        return this.params;
    }

    public ObjectNode getVendorParams() {
        return this.vendorParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<String> getForbidHeaders() {
        return this.forbidHeaders;
    }

    public List<String> getRequireHeaders() {
        return this.requireHeaders;
    }

    static void updateBuilderFromNode(Builder<?, ?> builder, Node node) {
        ObjectNode o = node.expectObjectNode();
        builder.id(o.expectStringMember(ID).getValue());
        builder.protocol(o.expectStringMember(PROTOCOL).expectShapeId());
        o.getStringMember(DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::documentation);
        o.getStringMember(AUTH_SCHEME).map(StringNode::expectShapeId).ifPresent(builder::authScheme);
        o.getStringMember(BODY).map(StringNode::getValue).ifPresent(builder::body);
        o.getStringMember(BODY_MEDIA_TYPE).map(StringNode::getValue).ifPresent(builder::bodyMediaType);
        o.getObjectMember(PARAMS).ifPresent(builder::params);
        o.getObjectMember(VENDOR_PARAMS).ifPresent(builder::vendorParams);
        o.getObjectMember(HEADERS).ifPresent(headers -> headers.getStringMap().forEach((k, v) -> builder.putHeader((String)k, v.expectStringNode().getValue())));
        o.getArrayMember(FORBID_HEADERS).ifPresent(headers -> builder.forbidHeaders(headers.getElementsAs(StringNode::getValue)));
        o.getArrayMember(REQUIRE_HEADERS).ifPresent(headers -> builder.requireHeaders(headers.getElementsAs(StringNode::getValue)));
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember(ID, this.getId()).withMember(PROTOCOL, this.getProtocol().toString()).withOptionalMember(DOCUMENTATION, this.getDocumentation().map(Node::from)).withOptionalMember(AUTH_SCHEME, this.getAuthScheme().map(ShapeId::toString).map(Node::from)).withOptionalMember(BODY, this.getBody().map(Node::from)).withOptionalMember(BODY_MEDIA_TYPE, this.getBodyMediaType().map(Node::from));
        if (!this.headers.isEmpty()) {
            builder.withMember(HEADERS, (ToNode)ObjectNode.fromStringMap(this.getHeaders()));
        }
        if (!this.forbidHeaders.isEmpty()) {
            builder.withMember(FORBID_HEADERS, (ToNode)ArrayNode.fromStrings(this.forbidHeaders));
        }
        if (!this.requireHeaders.isEmpty()) {
            builder.withMember(REQUIRE_HEADERS, (ToNode)ArrayNode.fromStrings(this.requireHeaders));
        }
        if (!this.params.isEmpty()) {
            builder.withMember(PARAMS, (ToNode)this.getParams());
        }
        if (!this.vendorParams.isEmpty()) {
            builder.withMember(VENDOR_PARAMS, (ToNode)this.getVendorParams());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((HttpMessageTestCase)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    void updateBuilder(Builder<?, ?> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.id(this.id)).headers(this.headers)).forbidHeaders(this.forbidHeaders)).requireHeaders(this.requireHeaders)).params(this.params)).vendorParams(this.vendorParams)).documentation(this.documentation)).authScheme(this.authScheme)).protocol(this.protocol)).body(this.body)).bodyMediaType(this.bodyMediaType);
    }

    static abstract class Builder<B extends Builder, T extends HttpMessageTestCase>
    implements SmithyBuilder<T> {
        private String id;
        private String documentation;
        private ShapeId protocol;
        private ShapeId authScheme;
        private String body;
        private String bodyMediaType;
        private ObjectNode params = Node.objectNode();
        private ObjectNode vendorParams = Node.objectNode();
        private final Map<String, String> headers = new TreeMap<String, String>();
        private final List<String> forbidHeaders = new ArrayList<String>();
        private final List<String> requireHeaders = new ArrayList<String>();

        Builder() {
        }

        public B id(String id) {
            this.id = id;
            return (B)this;
        }

        public B documentation(String documentation) {
            this.documentation = documentation;
            return (B)this;
        }

        public B protocol(ShapeId protocol) {
            this.protocol = protocol;
            return (B)this;
        }

        public B authScheme(ShapeId authScheme) {
            this.authScheme = authScheme;
            return (B)this;
        }

        public B body(String body) {
            this.body = body;
            return (B)this;
        }

        public B bodyMediaType(String bodyMediaType) {
            this.bodyMediaType = bodyMediaType;
            return (B)this;
        }

        public B params(ObjectNode params) {
            this.params = params;
            return (B)this;
        }

        public B vendorParams(ObjectNode vendorParams) {
            this.vendorParams = vendorParams;
            return (B)this;
        }

        public B headers(Map<String, String> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return (B)this;
        }

        public B putHeader(String key, String value) {
            this.headers.put(key, value);
            return (B)this;
        }

        public B forbidHeaders(List<String> forbidHeaders) {
            this.forbidHeaders.clear();
            this.forbidHeaders.addAll(forbidHeaders);
            return (B)this;
        }

        public B requireHeaders(List<String> requireHeaders) {
            this.requireHeaders.clear();
            this.requireHeaders.addAll(requireHeaders);
            return (B)this;
        }
    }
}

