/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.protocoltests.traits.HttpMalformedRequestDefinition;
import software.amazon.smithy.protocoltests.traits.HttpMalformedResponseDefinition;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class HttpMalformedRequestTestCase
implements Tagged,
ToSmithyBuilder<HttpMalformedRequestTestCase> {
    private static final String ID = "id";
    private static final String PROTOCOL = "protocol";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private final String documentation;
    private final String id;
    private final ShapeId protocol;
    private final HttpMalformedRequestDefinition request;
    private final HttpMalformedResponseDefinition response;
    private final List<String> tags;

    private HttpMalformedRequestTestCase(Builder builder) {
        this.documentation = builder.documentation;
        this.id = (String)SmithyBuilder.requiredState((String)ID, (Object)builder.id);
        this.protocol = (ShapeId)SmithyBuilder.requiredState((String)PROTOCOL, (Object)builder.protocol);
        this.request = (HttpMalformedRequestDefinition)SmithyBuilder.requiredState((String)REQUEST, (Object)builder.request);
        this.response = (HttpMalformedResponseDefinition)SmithyBuilder.requiredState((String)RESPONSE, (Object)builder.response);
        this.tags = (List)builder.tags.copy();
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public String getId() {
        return this.id;
    }

    public ShapeId getProtocol() {
        return this.protocol;
    }

    public HttpMalformedRequestDefinition getRequest() {
        return this.request;
    }

    public HttpMalformedResponseDefinition getResponse() {
        return this.response;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Builder toBuilder() {
        Builder builder = HttpMalformedRequestTestCase.builder().id(this.getId()).protocol((ToShapeId)this.getProtocol()).request(this.getRequest()).response(this.getResponse()).tags(this.getTags());
        this.getDocumentation().ifPresent(builder::documentation);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<HttpMalformedRequestTestCase> {
        private String documentation;
        private String id;
        private ShapeId protocol;
        private HttpMalformedRequestDefinition request;
        private HttpMalformedResponseDefinition response;
        private final BuilderRef<List<String>> tags = BuilderRef.forList();

        private Builder() {
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder protocol(ToShapeId protocol) {
            this.protocol = protocol.toShapeId();
            return this;
        }

        public Builder request(HttpMalformedRequestDefinition request) {
            this.request = request;
            return this;
        }

        public Builder response(HttpMalformedResponseDefinition response) {
            this.response = response;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags.clear();
            ((List)this.tags.get()).addAll(tags);
            return this;
        }

        public HttpMalformedRequestTestCase build() {
            return new HttpMalformedRequestTestCase(this);
        }
    }
}

