/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.Collection;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.smoketests.traits.FailureExpectation;
import software.amazon.smithy.utils.ListUtils;

public final class Expectation
implements ToNode {
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private final FailureExpectation failure;

    private Expectation(FailureExpectation failure) {
        this.failure = failure;
    }

    public static Expectation success() {
        return new Expectation(null);
    }

    public static Expectation failure(FailureExpectation failure) {
        return new Expectation(failure);
    }

    public static Expectation fromNode(Node node) {
        ObjectNode o = node.expectObjectNode();
        if (o.containsMember(SUCCESS)) {
            o.expectNoAdditionalProperties((Collection)ListUtils.of((Object)SUCCESS));
            return Expectation.success();
        }
        if (o.containsMember(FAILURE)) {
            o.expectNoAdditionalProperties((Collection)ListUtils.of((Object)FAILURE));
            FailureExpectation failure = FailureExpectation.fromNode((Node)o.expectObjectMember(FAILURE));
            return Expectation.failure(failure);
        }
        throw new ExpectationNotMetException("Expected an object with exactly one `success` or `failure` property, but found properties: " + ValidationUtils.tickedList(o.getStringMap().keySet()), (FromSourceLocation)o);
    }

    public boolean isSuccess() {
        return this.failure == null;
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public Optional<FailureExpectation> getFailure() {
        return Optional.ofNullable(this.failure);
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (this.isSuccess()) {
            builder.withMember(SUCCESS, (ToNode)Node.objectNode());
        } else {
            Node failureNode = this.getFailure().map(FailureExpectation::toNode).orElse((Node)Node.objectNode());
            builder.withMember(FAILURE, (ToNode)failureNode);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((Expectation)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }
}

