/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;

public final class FailureExpectation
implements ToNode {
    private static final String ERROR_ID = "errorId";
    private final ShapeId errorId;

    private FailureExpectation(ShapeId errorId) {
        this.errorId = errorId;
    }

    public static FailureExpectation anyError() {
        return new FailureExpectation(null);
    }

    public static FailureExpectation errorWithId(ShapeId errorId) {
        return new FailureExpectation(errorId);
    }

    public Optional<ShapeId> getErrorId() {
        return Optional.ofNullable(this.errorId);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withOptionalMember(ERROR_ID, this.getErrorId().map(ShapeId::toString).map(Node::from)).build();
    }

    public static FailureExpectation fromNode(Node node) {
        ObjectNode o = node.expectObjectNode();
        return o.getStringMember(ERROR_ID).map(ShapeId::fromNode).map(FailureExpectation::errorWithId).orElse(FailureExpectation.anyError());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((FailureExpectation)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }
}

