/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.smoketests.traits.Expectation;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SmokeTestCase
implements Tagged,
ToNode,
ToSmithyBuilder<SmokeTestCase> {
    private static final String ID = "id";
    private static final String PARAMS = "params";
    private static final String VENDOR_PARAMS = "vendorParams";
    private static final String VENDOR_PARAMS_SHAPE = "vendorParamsShape";
    private static final String EXPECT = "expect";
    private static final String TAGS = "tags";
    private final String id;
    private final ObjectNode params;
    private final ObjectNode vendorParams;
    private final ShapeId vendorParamsShape;
    private final Expectation expectation;
    private final List<String> tags;

    private SmokeTestCase(Builder builder) {
        this.id = (String)SmithyBuilder.requiredState((String)ID, (Object)builder.id);
        this.params = builder.params;
        this.vendorParams = builder.vendorParams;
        this.vendorParamsShape = builder.vendorParamsShape;
        this.expectation = (Expectation)SmithyBuilder.requiredState((String)EXPECT, (Object)builder.expectation);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SmokeTestCase fromNode(Node node) {
        Builder builder = SmokeTestCase.builder();
        ObjectNode o = node.expectObjectNode();
        builder.id(o.expectStringMember(ID).getValue());
        o.getObjectMember(PARAMS).ifPresent(builder::params);
        o.getObjectMember(VENDOR_PARAMS).ifPresent(builder::vendorParams);
        o.getStringMember(VENDOR_PARAMS_SHAPE).map(StringNode::expectShapeId).ifPresent(builder::vendorParamsShape);
        builder.expectation(Expectation.fromNode((Node)o.expectObjectMember(EXPECT)));
        o.getArrayMember(TAGS).ifPresent(tags -> builder.tags(tags.getElementsAs(StringNode::getValue)));
        return builder.build();
    }

    public String getId() {
        return this.id;
    }

    public Optional<ObjectNode> getParams() {
        return Optional.ofNullable(this.params);
    }

    public Optional<ObjectNode> getVendorParams() {
        return Optional.ofNullable(this.vendorParams);
    }

    public Optional<ShapeId> getVendorParamsShape() {
        return Optional.ofNullable(this.vendorParamsShape);
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return SmokeTestCase.builder().id(this.getId()).params(this.getParams().orElse(null)).vendorParams(this.getVendorParams().orElse(null)).vendorParamsShape(this.getVendorParamsShape().orElse(null)).expectation(this.getExpectation()).tags(this.getTags());
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember(ID, this.getId()).withOptionalMember(PARAMS, this.getParams()).withOptionalMember(VENDOR_PARAMS, this.getVendorParams()).withOptionalMember(VENDOR_PARAMS_SHAPE, this.getVendorParamsShape().map(ShapeId::toString).map(Node::from)).withMember(EXPECT, (ToNode)this.getExpectation());
        if (!this.tags.isEmpty()) {
            builder.withMember(TAGS, (ToNode)ArrayNode.fromStrings(this.tags));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.toNode().equals(((SmokeTestCase)o).toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    public static final class Builder
    implements SmithyBuilder<SmokeTestCase> {
        private String id;
        private ObjectNode params;
        private ObjectNode vendorParams;
        private ShapeId vendorParamsShape;
        private Expectation expectation;
        private final List<String> tags = new ArrayList<String>();

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder params(ObjectNode params) {
            this.params = params;
            return this;
        }

        public Builder vendorParams(ObjectNode vendorParams) {
            this.vendorParams = vendorParams;
            return this;
        }

        public Builder vendorParamsShape(ShapeId vendorParamsShape) {
            this.vendorParamsShape = vendorParamsShape;
            return this;
        }

        public Builder expectation(Expectation expectation) {
            this.expectation = expectation;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public SmokeTestCase build() {
            return new SmokeTestCase(this);
        }
    }
}

