/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.smoketests.traits.SmokeTestCase;
import software.amazon.smithy.smoketests.traits.SmokeTestsTrait;

public class SmokeTestCaseValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(SmokeTestsTrait.class)) {
            SmokeTestsTrait trait = (SmokeTestsTrait)shape.expectTrait(SmokeTestsTrait.class);
            List<SmokeTestCase> testCases = trait.getTestCases();
            for (SmokeTestCase testCase : testCases) {
                Optional<ShapeId> vendorParamsShapeIdOptional = testCase.getVendorParamsShape();
                Optional<ObjectNode> vendorParamsOptional = testCase.getVendorParams();
                if (vendorParamsShapeIdOptional.isPresent()) {
                    if (!vendorParamsOptional.isPresent()) {
                        events.add(this.warning(shape, (FromSourceLocation)trait, String.format("Smoke test case with ID `%s` defined a `vendorParamsShape` but no `vendorParams`", testCase.getId())));
                    } else {
                        Optional vendorParamsShapeOptional = model.getShape(vendorParamsShapeIdOptional.get());
                        if (vendorParamsShapeOptional.isPresent()) {
                            Shape vendorParamsShape = (Shape)vendorParamsShapeOptional.get();
                            NodeValidationVisitor vendorParamsValidator = this.createVisitor(vendorParamsOptional.get(), model, shape, testCase.getId(), ".vendorParams");
                            events.addAll((Collection)vendorParamsShape.accept((ShapeVisitor)vendorParamsValidator));
                        }
                    }
                } else if (vendorParamsOptional.isPresent()) {
                    events.add(this.warning(shape, (FromSourceLocation)trait, String.format("Smoke test case with ID `%s` defined `vendorParams` but no `vendorParamsShape`", testCase.getId())));
                }
                StructureShape input = operationIndex.expectInputShape((ToShapeId)shape);
                if (input != null && testCase.getParams().isPresent()) {
                    NodeValidationVisitor paramsValidator = this.createVisitor(testCase.getParams().get(), model, shape, testCase.getId(), ".params");
                    events.addAll((Collection)input.accept((ShapeVisitor)paramsValidator));
                    continue;
                }
                if (!testCase.getParams().isPresent()) continue;
                events.add(this.error(shape, (FromSourceLocation)trait, String.format("Smoke test parameters provided for operation with no input: `%s`", Node.printJson((Node)((Node)testCase.getParams().get())))));
            }
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(ObjectNode node, Model model, Shape shape, String caseId, String contextSuffix) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value((Node)node).startingContext(SmokeTestsTrait.ID + "." + caseId + contextSuffix).eventId(this.getName()).timestampValidationStrategy(TimestampValidationStrategy.EPOCH_SECONDS).addFeature(NodeValidationVisitor.Feature.ALLOW_OPTIONAL_NULLS).build();
    }
}

